import React from 'react';

import { __ } from '@wordpress/i18n';

const Header = ({ utm = 'wpuf-header' }) => {
    // You may want to get wpuf_admin_script from context or props
    const wpuf = wpuf_admin_script;
    const logoUrl = wpuf.asset_url + '/images/wpuf-icon-circle.svg';
    const upgradeUrl = wpuf.upgradeUrl + '?utm_source=' + utm + '&utm_medium=wpuf-header';
    const supportUrl = wpuf.support_url;

    return (
        <div className="wpuf-w-[calc(100%+40px)] wpuf-ml-[-20px] wpuf-px-[20px] wpuf-flex wpuf-justify-between wpuf-items-center wpuf-border-b-2 wpuf-border-gray-100">
            <div className="wpuf-flex wpuf-justify-start wpuf-items-center">
                <img src={logoUrl} alt="WPUF Icon" className="wpuf-w-12 wpuf-mr-4" />
                <h2 className="wpuf-text-2xl wpuf-leading-7 wpuf-font-bold">WP User Frontend Pro</h2>
                {
                    wpuf.pro_version && (
                        <span className="wpuf-ml-2 wpuf-inline-flex wpuf-items-center wpuf-rounded-full wpuf-bg-green-100 wpuf-px-2 wpuf-py-1 wpuf-text-xs wpuf-font-medium wpuf-text-green-700 wpuf-ring-1 wpuf-ring-inset wpuf-ring-green-600/20">
                            v{wpuf.pro_version}
                        </span>
                    )
                }
            </div>
            <div className="wpuf-flex wpuf-justify-end wpuf-items-center wpuf-w-2/4">
                <span
                    id="wpuf-headway-icon"
                    className="wpuf-border wpuf-border-gray-100 wpuf-mr-[16px] wpuf-rounded-full wpuf-p-1 wpuf-shadow-sm hover:wpuf-bg-slate-100 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2"
                ></span>
                <a
                    className="wpuf-flex wpuf-border wpuf-border-gray-100 wpuf-mr-[16px] wpuf-canny-link wpuf-text-center wpuf-rounded-md wpuf-px-3 wpuf-py-2 wpuf-text-sm wpuf-font-semibold wpuf-shadow-sm hover:wpuf-bg-slate-100 focus:wpuf-bg-slate-100"
                    target="_blank"
                    rel="noopener noreferrer"
                    href="https://wpuf.canny.io/ideas"
                >
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M11.5 15.5V16C11.5 16.8284 10.8284 17.5 10 17.5C9.17157 17.5 8.5 16.8284 8.5 16V15.5H11.5ZM10 6.5C11.933 6.5 13.5 8.067 13.5 10C13.5 11.0448 13.0424 11.9821 12.3154 12.624L12.167 12.749C11.9287 12.9372 11.7214 13.1942 11.6035 13.5H8.39648C8.30049 13.251 8.14623 13.0337 7.96289 12.8604L7.83301 12.749C7.02019 12.1072 6.5 11.1144 6.5 10C6.5 8.067 8.067 6.5 10 6.5ZM3 9.5H4C4.27614 9.5 4.5 9.72386 4.5 10C4.5 10.2761 4.27614 10.5 4 10.5H3C2.72386 10.5 2.5 10.2761 2.5 10C2.5 9.72386 2.72386 9.5 3 9.5ZM16 9.5H17C17.2761 9.5 17.5 9.72386 17.5 10C17.5 10.2761 17.2761 10.5 17 10.5H16C15.7239 10.5 15.5 10.2761 15.5 10C15.5 9.72386 15.7239 9.5 16 9.5ZM4.69629 4.69629C4.86715 4.52544 5.13112 4.50466 5.3252 4.63281L5.40332 4.69629L6.11133 5.40332C6.30657 5.59858 6.30657 5.91607 6.11133 6.11133C5.9405 6.28215 5.67649 6.30287 5.48242 6.1748L5.40332 6.11133L4.69629 5.40332C4.52583 5.23248 4.50484 4.96931 4.63281 4.77539L4.69629 4.69629ZM14.5957 4.69629C14.7665 4.52545 15.0305 4.5047 15.2246 4.63281L15.3037 4.69629C15.4745 4.86714 15.4953 5.13114 15.3672 5.3252L15.3037 5.40332L14.5957 6.11133C14.4249 6.28172 14.1617 6.30272 13.9678 6.1748L13.8887 6.11133C13.7178 5.94049 13.6971 5.67649 13.8252 5.48242L13.8887 5.40332L14.5957 4.69629ZM10 2.5C10.2761 2.5 10.5 2.72386 10.5 3V4C10.5 4.27614 10.2761 4.5 10 4.5C9.72386 4.5 9.5 4.27614 9.5 4V3C9.5 2.72386 9.72386 2.5 10 2.5Z" stroke="#6B7280"/>
                    </svg>
                    <span className="wpuf-ml-2">
                        {__('Submit Ideas', 'wpuf-pro')}
                    </span>
                </a>
                <a
                    href={supportUrl}
                    target="_blank"
                    rel="noopener noreferrer"
                    className="wpuf-rounded-md wpuf-text-center wpuf-bg-primary wpuf-px-3 wpuf-py-2 wpuf-text-sm wpuf-font-semibold wpuf-text-white wpuf-shadow-sm hover:wpuf-bg-primaryHover hover:wpuf-text-white focus:wpuf-bg-primaryHover focus:wpuf-text-white"
                >
                    {__('Support ', 'wpuf-pro')}
                    &nbsp;&nbsp;
                    <span className="dashicons dashicons-businessman"></span>
                </a>
            </div>
        </div>
    );
};

export default Header;
