<tr class="wpuf-ud-row">
    <?php
    foreach ( $columns as $column ) {
        ?>
        <td class="wpuf-p-4 wpuf-text-sm wpuf-text-gray-900 wpuf-text-center !wpuf-border-none">
            <?php
            switch ( $column ) {
                case 'avatar':
                    // Check if we have block styling available
                    if ( isset( $styling_helper ) && is_callable( $styling_helper ) ) {
                        // Use block-based avatar rendering with dynamic styling
                        $avatar_attributes = $block_attributes['user_avatar'] ?? [];
                        $styling = call_user_func( $styling_helper, $avatar_attributes, 'user-avatar' );
                        
                        // Get avatar display data
                        $avatar_size = $avatar_attributes['avatarSize'] ?? 'thumbnail';
                        $custom_size = $avatar_attributes['customSize'] ?? 150;
                        $display_size = wpuf_ud_get_avatar_display_size( $avatar_size, $custom_size );
                        
                        // Use the common avatar function with fallbacks
                        $avatar_html = wpuf_ud_get_user_avatar_html( $user, $display_size, 'wpuf-avatar--image' );
                        
                        // Render avatar with dynamic styling
                        ?>
                        <div class="<?php echo esc_attr( $styling['classes'] ); ?>" 
                             style="<?php echo wpuf_build_inline_styles( $styling['styles'] ); ?>">
                            <?php echo $avatar_html; ?>
                        </div>
                        <?php
                    } else {
                        // Fallback to shortcode-style avatar rendering using the common function
                        $table_avatar_size = ! empty( $avatar_size ) ? $avatar_size : 40;
                        $size_class = '!wpuf-w-[' . $table_avatar_size . 'px] !wpuf-h-[' . $table_avatar_size . 'px]';
                        echo wpuf_ud_get_user_avatar_html( $user, $table_avatar_size, $size_class . ' !wpuf-rounded-[36px] !wpuf-object-cover' );
                    }
                    break;
                    
                case 'name':
                    // Check if we have block styling available
                    if ( isset( $styling_helper ) && is_callable( $styling_helper ) ) {
                        $name_attributes = $block_attributes['user_name'] ?? [];
                        $styling = call_user_func( $styling_helper, $name_attributes, 'user-name' );
                        ?>
                        <div class="<?php echo esc_attr( $styling['classes'] ); ?>" 
                             style="<?php echo wpuf_build_inline_styles( $styling['styles'] ); ?>">
                            <?php echo esc_html( $user->display_name ?: $user->user_login ); ?>
                        </div>
                        <?php
                    } else {
                        // Fallback to shortcode-style name rendering
                        ?>
                        <div class="wpuf-user-name">
                            <?php echo esc_html( $user->display_name ?: $user->user_login ); ?>
                        </div>
                        <?php
                    }
                    break;
                    
                case 'email':
                    ?>
                    <div class="wpuf-user-email">
                        <a href="mailto:<?php echo antispambot( esc_attr( $user->user_email ) ); ?>" class="!wpuf-text-gray-700 !wpuf-no-underline hover:!wpuf-underline">
                            <?php echo antispambot( esc_html( $user->user_email ) ); ?>
                        </a>
                    </div>
                    <?php
                    break;
                    
                case 'role':
                    ?>
                    <div class="wpuf-user-role">
                        <?php
                        $user_roles = $user->roles;
                        if ( ! empty( $user_roles ) ) {
                            $role_names = [];
                            foreach ( $user_roles as $role ) {
                                $role_names[] = wp_roles()->get_names()[ $role ] ?? $role;
                            }
                            echo esc_html( implode( ', ', $role_names ) );
                        }
                        ?>
                    </div>
                    <?php
                    break;
                    
                case 'posts':
                    ?>
                    <div class="wpuf-user-posts">
                        <?php
                        $post_count = count_user_posts( $user->ID );
                        echo esc_html( $post_count );
                        ?>
                    </div>
                    <?php
                    break;
                    
                case 'joined':
                    ?>
                    <div class="wpuf-user-joined">
                        <?php
                        $registered_date = $user->user_registered;
                        echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $registered_date ) ) );
                        ?>
                    </div>
                    <?php
                    break;
                    
                case 'user_login':
                    ?>
                    <div class="wpuf-user-login">
                        <?php echo esc_html( $user->user_login ); ?>
                    </div>
                    <?php
                    break;
                    
                case 'display_name':
                    ?>
                    <div class="wpuf-user-display-name">
                        <?php echo esc_html( $user->display_name ); ?>
                    </div>
                    <?php
                    break;
                    
                case 'user_email':
                    ?>
                    <div class="wpuf-user-email">
                        <?php echo esc_html( $user->user_email ); ?>
                    </div>
                    <?php
                    break;
                    
                case 'website':
                case 'user_url':
                    ?>
                    <div class="wpuf-user-website">
                        <?php if ( ! empty( $user->user_url ) ) : ?>
                            <a href="<?php echo esc_url( $user->user_url ); ?>" target="_blank" rel="noopener">
                                <?php echo esc_html( $user->user_url ); ?>
                            </a>
                        <?php else : ?>
                            <span class="wpuf-text-gray-400">-</span>
                        <?php endif; ?>
                    </div>
                    <?php
                    break;
                    
                default:
                    // Check if this is a meta field
                    $meta_value = '';
                    
                    // First check if value is already set on user object (pre-loaded)
                    if ( isset( $user->$column ) ) {
                        $meta_value = $user->$column;
                    } else {
                        // Fallback to get_user_meta for dynamic loading
                        $meta_value = get_user_meta( $user->ID, $column, true );
                    }
                    
                    // Check if ALL custom meta fields are empty for this user
                    $basic_fields = ['avatar', 'name', 'email', 'display_name', 'user_email', 'user_login', 'role', 'posts', 'joined', 'website', 'user_url'];
                    $show_empty_placeholder = true;
                    
                    // Only show placeholder if other meta fields have data
                    $has_any_meta = false;
                    foreach ( $columns as $col ) {
                        if ( !in_array( $col, $basic_fields ) ) {
                            $col_value = isset( $user->$col ) ? $user->$col : get_user_meta( $user->ID, $col, true );
                            if ( !empty( $col_value ) && $col_value !== '-1' ) {
                                $has_any_meta = true;
                                break;
                            }
                        }
                    }
                    
                    ?>
                    <div class="wpuf-user-field wpuf-user-field-<?php echo esc_attr( $column ); ?>">
                        <?php 
                        if ( ! empty( $meta_value ) ) {
                            if ( is_array( $meta_value ) ) {
                                echo esc_html( implode( ', ', $meta_value ) );
                            } elseif ( filter_var( $meta_value, FILTER_VALIDATE_URL ) ) {
                                // If it's a URL, make it clickable
                                ?>
                                <a href="<?php echo esc_url( $meta_value ); ?>" target="_blank" rel="noopener">
                                    <?php echo esc_html( $meta_value ); ?>
                                </a>
                                <?php
                            } else {
                                echo esc_html( $meta_value );
                            }
                        } else {
                            // If no user has any meta data, show just basic info in a cleaner way
                            if ( !$has_any_meta ) {
                                // Don't show placeholder for empty meta fields when no meta data exists
                                echo '';
                            } else {
                                // Show placeholder only if other users have meta data
                                echo '<span class="wpuf-text-gray-400">-</span>';
                            }
                        }
                        ?>
                    </div>
                    <?php
                    break;
            }
            ?>
        </td>
        <?php
    }
    ?>
    <td class="wpuf-p-4 wpuf-text-sm wpuf-text-gray-900 wpuf-text-center">
        <?php
        if ( ! empty( $profile_url_helper ) && is_callable( $profile_url_helper ) ) {
            // Get profile permalink type from all_data
            $profile_permalink = ! empty( $all_data['profile_permalink'] ) ? $all_data['profile_permalink'] : 'username';
            $profile_url = call_user_func( $profile_url_helper, $user, $profile_permalink );
        } else {
            // Prepare data for wpuf_ud_get_profile_url with profile_base key
            $profile_data = ! empty( $all_data ) ? $all_data : [];
            $profile_data['profile_base'] = ! empty( $all_data['profile_permalink'] ) ? $all_data['profile_permalink'] : 'username';
            $profile_url = wpuf_ud_get_profile_url( $user, $profile_data );
        }

        // Add directory state parameters to preserve pagination context
        $dir_params = [];

        // Get current page number - WordPress stores this in paged or page
        $current_page = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : get_query_var( 'page' );
        if ( ! $current_page ) {
            $current_page = isset( $_GET['page'] ) ? intval( $_GET['page'] ) : 1;
        }

        if ( $current_page > 1 ) {
            $dir_params['dir_page'] = $current_page;
        }

        // Preserve sorting and search parameters
        if ( isset( $_GET['orderby'] ) ) {
            $dir_params['orderby'] = sanitize_text_field( $_GET['orderby'] );
        }
        if ( isset( $_GET['order'] ) ) {
            $dir_params['order'] = sanitize_text_field( $_GET['order'] );
        }
        if ( isset( $_GET['search'] ) ) {
            $dir_params['search'] = sanitize_text_field( $_GET['search'] );
        }

        // Add parameters to profile URL if any exist
        if ( ! empty( $dir_params ) ) {
            $profile_url = add_query_arg( $dir_params, $profile_url );
        }
        ?>
        <a href="<?php echo esc_url( $profile_url ); ?>"
           class="!wpuf-inline-block !wpuf-px-6 !wpuf-py-2 !wpuf-bg-blue-500 !wpuf-text-white !wpuf-rounded-md !wpuf-text-sm !wpuf-font-medium hover:!wpuf-bg-blue-700 focus:!wpuf-outline-none focus:!wpuf-ring-2 focus:!wpuf-ring-blue-500 focus:!wpuf-ring-offset-2 !wpuf-no-underline">
            <?php esc_html_e( 'View Profile', 'wpuf-pro' ); ?>
        </a>
    </td>
</tr>
