<?php

/**
 * Class Toolset_Compatibility_Theme_generatepress
 * @since layouts 2.0.2
 */
class Toolset_Compatibility_Theme_generatepress extends Toolset_Compatibility_Theme_Handler{


	protected function run_hooks() {
		add_action( 'get_header', array( $this, 'disable_featured_image' ) );
		add_action( 'get_header', array( $this, 'disable_pagination' ) );
		add_action( 'get_header', array( $this, 'disable_read_more_in_excerpt') );
		add_action( 'get_header', array( $this, 'disable_title' ) );
		add_action( 'get_header', array( $this, 'disable_archive_title') );
		add_action( 'get_header', array( $this, 'disable_post_meta_info') );

		// When GeneratePress builds its cache for inlined pieces of CSS, it does it on init hook, earlier than our
		// global theme settings are hooked, and then they aren't applied. Skipping the cache fixes our settings, while
		// it doesn't seem to impact the performance in any measurable way, so there aren't any strong guilt feelings
		// for doing this.
		add_filter( 'generate_dynamic_css_skip_cache', '__return_true', 20 );
	}


	public function disable_archive_title(){
		$toolset_disable_archive_title = apply_filters( 'toolset_theme_integration_get_setting', null, 'toolset_disable_title' );

		if (
			"1" == $toolset_disable_archive_title
			&& ( is_archive() || is_home() || is_search() )
		) {
			remove_action( 'generate_archive_title','generate_archive_title' );
		}
	}

	/**
	 * Remove post meta info when necessary.
	 */
	public function disable_post_meta_info(){
		$toolset_disable_post_meta_info =  apply_filters( 'toolset_theme_integration_get_setting', null, 'toolset_disable_post_meta_info' );

		if ( "1" == $toolset_disable_post_meta_info ) {
			if( is_single() ){
				remove_action( 'generate_after_entry_title', 'generate_post_meta' );
			}
		}
	}

	/**
	 * Get value from theme integration settings filter and disable featured image for current page if option is enabled
	 */
	public function disable_featured_image() {
		$toolset_disable_featured_image = apply_filters( 'toolset_theme_integration_get_setting', null, 'toolset_disable_featured_image' );

		if ( "1" == $toolset_disable_featured_image ) {
			if( is_single() ){
				remove_action( 'generate_before_content','generate_featured_page_header_inside_single', 10 );
			} elseif( is_page() ){
				remove_action( 'generate_after_header', 'generate_featured_page_header', 10 );
			}
		}
	}

	/**
	 * Remove "Read more" link from excerpt when option is enabled
	 */
	public function disable_read_more_in_excerpt(){
		$toolset_disable_read_more_in_excerpt = apply_filters( 'toolset_theme_integration_get_setting', null, 'toolset_disable_read_more_for_excerpt' );

		if ( "1" == $toolset_disable_read_more_in_excerpt ) {
			remove_filter( 'excerpt_more', 'generate_excerpt_more' );
		}
	}

	/**
	 * Get value from theme integration settings filter and disable pagination image for current page if option is enabled.
	 * @todo Turn this into a "control_filters" setting with proper migration.
	 */
	public function disable_pagination() {
		$toolset_disable_pagination = apply_filters( 'toolset_theme_integration_get_setting', null, 'toolset_disable_pagination' );

		if ( "1" == $toolset_disable_pagination ) {
			add_filter( 'generate_show_post_navigation', '__return_false' );
			// WooCommerce archives.
			add_filter( 'woocommerce_pagination_args', [ $this, 'force_disable_product_archive_pagination' ] );
		}
	}

	/**
	 * Force disable archive pagination generated by WooCommerce.
	 *
	 * @param mixed[] $args
	 * @return mixed[]
	 */
	public function force_disable_product_archive_pagination( $args ) {
		$args[ 'total' ] = 1;
		return $args;
	}

	/**
	 * Get value from theme integration settings filter and disable title for current page if option is enabled
	 */
	public function disable_title() {
		$toolset_disable_title = apply_filters( 'toolset_theme_integration_get_setting', null, 'toolset_disable_title' );

		if ( "1" == $toolset_disable_title ) {
			add_filter( 'the_title', array( $this, 'remove_title' ), 10, 2 );
			return true;
		}
		return false;
	}

	public function remove_title( $title, $id ) {

		if ( in_the_loop() ) {
			remove_filter( 'the_title', array( $this, 'remove_title' ), 10, 2 );
			return '';
		}

		return $title;
	}

}
