<?php

if ( !defined( 'ABSPATH' ) ) {
    exit;
}
// Exit if accessed directly
function wpsummarize_admin_menu() {
    // Main menu page
    add_menu_page(
        esc_html__( 'WPSummarize Dashboard', 'wpsummarize' ),
        // Page title
        esc_html__( 'WPSummarize', 'wpsummarize' ),
        // Menu title
        'manage_options',
        // Capability
        'wpsummarize',
        // Menu slug
        'wpsummarize_dashboard_page',
        // Function to display the dashboard page
        'data:image/svg+xml;base64,' . base64_encode( wpsummarize_sanitize_svg( '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="#a7aaad"><path d="M4 4c0-1.1.9-2 2-2h12c1.1 0 2 .9 2 2v16c0 1.1-.9 2-2 2H6c-1.1 0-2-.9-2-2V4zm2 0v16h12V4H6zm2 3h8v2H8V7zm0 4h8v2H8v-2zm0 4h8v2H8v-2z"/></svg>' ) )
    );
    // Manually add the Dashboard submenu page that matches the main menu
    add_submenu_page(
        'wpsummarize',
        // Parent slug, matching the main menu slug
        esc_html__( 'WPSummarize Dashboard', 'wpsummarize' ),
        // Page title
        esc_html__( 'Dashboard', 'wpsummarize' ),
        // Menu title
        'manage_options',
        // Capability
        'wpsummarize',
        // Menu slug, same as main menu to actually link to the main menu item
        'wpsummarize_dashboard_page'
    );
    // Additional submenu page for settings
    add_submenu_page(
        'wpsummarize',
        // Parent slug, matching the main menu slug
        esc_html__( 'WPSummarize Settings', 'wpsummarize' ),
        // Page title
        esc_html__( 'Settings', 'wpsummarize' ),
        // Menu title
        'manage_options',
        // Capability
        'wpsummarize_settings',
        // Menu slug
        'wpsummarize_settings_page'
    );
}

function wpsummarize_display_user_message() {
    if ( wpsummarize_fs()->is_trial() ) {
        ?>
    	<div class="notice notice-info wpsummarize-trial-notice" style="border-left-color: #2271b1; padding: 20px; margin: 20px 0; background: #f0f6fc;">
    		<h3 style="margin-top: 0; color: #2271b1;">
    			<span class="dashicons dashicons-star-filled" style="font-size: 20px; vertical-align: middle;"></span>
    			<?php 
        esc_html_e( 'Exploring All Features? You\'re On the Right Track!', 'wpsummarize' );
        ?>
    		</h3>
    		
    		<p style="font-size: 14px; line-height: 1.6;">
    			<?php 
        printf( 
            /* translators: %s: "trial account" text */
            esc_html__( 'You\'re currently using a %s with full access to explore everything our plugin has to offer:', 'wpsummarize' ),
            '<strong>' . esc_html__( 'trial account', 'wpsummarize' ) . '</strong>'
         );
        ?>
    		</p>
    		
    		<ul style="font-size: 14px; line-height: 1.8; margin: 15px 0;">
    			<li>
    				<span class="dashicons dashicons-yes-alt" style="color: #00a32a;"></span>
    				<?php 
        esc_html_e( 'Batch processing for multiple posts at once', 'wpsummarize' );
        ?>
    			</li>
    			<li>
    				<span class="dashicons dashicons-yes-alt" style="color: #00a32a;"></span>
    				<?php 
        esc_html_e( 'All AI providers (OpenAI, Gemini, Anthropic)', 'wpsummarize' );
        ?>
    			</li>
    			<li>
    				<span class="dashicons dashicons-yes-alt" style="color: #00a32a;"></span>
    				<?php 
        esc_html_e( 'Custom settings per post', 'wpsummarize' );
        ?>
    			</li>
    			<li>
    				<span class="dashicons dashicons-yes-alt" style="color: #00a32a;"></span>
    				<?php 
        esc_html_e( 'Advanced configuration options', 'wpsummarize' );
        ?>
    			</li>
    		</ul>
    		
    		<p style="font-size: 14px; background: #fff; padding: 12px; border-left: 3px solid #2271b1; margin: 15px 0;">
    			<strong><?php 
        esc_html_e( 'Trial Limit:', 'wpsummarize' );
        ?></strong>
    			<?php 
        printf( 
            /* translators: %d: Number of summaries */
            esc_html__( '%d summaries', 'wpsummarize' ),
            250
         );
        ?>
    		</p>
    		
    		<p style="font-size: 14px; line-height: 1.6;">
    			<?php 
        esc_html_e( 'Once you\'ve reached your limit, you\'ll need to upgrade to continue generating summaries. Ready to unlock unlimited potential?', 'wpsummarize' );
        ?>
    		</p>
    		
    		<p style="margin-top: 20px;">
    			<a href="<?php 
        echo esc_url( wpsummarize_fs()->get_upgrade_url() );
        ?>" class="button button-primary button-hero" style="text-decoration: none;">
    				<span class="dashicons dashicons-unlock" style="vertical-align: middle;"></span>
    				<?php 
        esc_html_e( 'Upgrade Now', 'wpsummarize' );
        ?>
    			</a>
    		</p>
    	</div>
    	<?php 
    } elseif ( wpsummarize_fs()->is_free_plan() ) {
        // Premium features list.
        $features = array(
            array(
                'icon'        => 'dashicons-update',
                'title'       => __( 'Batch Processing', 'wpsummarize' ),
                'description' => __( 'Summarize multiple posts simultaneously', 'wpsummarize' ),
            ),
            array(
                'icon'        => 'dashicons-admin-settings',
                'title'       => __( 'Per-Post Settings', 'wpsummarize' ),
                'description' => __( 'Customize AI behavior for individual posts', 'wpsummarize' ),
            ),
            array(
                'icon'        => 'dashicons-superhero',
                'title'       => __( 'Premium AI Providers', 'wpsummarize' ),
                'description' => __( 'Access Gemini and Anthropic (Claude) models', 'wpsummarize' ),
            ),
            array(
                'icon'        => 'dashicons-chart-line',
                'title'       => __( 'Higher Limits', 'wpsummarize' ),
                'description' => __( 'Generate hundreds or thousands of summaries', 'wpsummarize' ),
            ),
            array(
                'icon'        => 'dashicons-sos',
                'title'       => __( 'Priority Support', 'wpsummarize' ),
                'description' => __( 'Get help when you need it', 'wpsummarize' ),
            ),
            array(
                'icon'        => 'dashicons-editor-code',
                'title'       => __( 'Advanced Templates', 'wpsummarize' ),
                'description' => __( 'More control over summary output', 'wpsummarize' ),
            )
        );
        // Allow filtering of features.
        $features = apply_filters( 'wpsummarize_premium_features', $features );
        ?>
    	<div class="notice notice-warning wpsummarize-free-notice" style="border-left-color: #dba617; padding: 20px; margin: 20px 0; background: #fcf9e8;">
    		<h3 style="margin-top: 0; color: #996800;">
    			<span class="dashicons dashicons-info" style="font-size: 20px; vertical-align: middle;"></span>
    			<?php 
        esc_html_e( 'You\'re Using the Free Plan', 'wpsummarize' );
        ?>
    		</h3>
    		
    		<p style="font-size: 14px; line-height: 1.6; background: #fff; padding: 12px; border-left: 3px solid #dba617; margin: 15px 0;">
    			<?php 
        printf( 
            /* translators: %s: Number of summaries per month */
            esc_html__( 'Your account includes %s to help you get started with AI-powered content summarization.', 'wpsummarize' ),
            '<strong>' . sprintf( 
                /* translators: %d: Number of summaries */
                esc_html__( '%d summaries per month', 'wpsummarize' ),
                50
             ) . '</strong>'
         );
        ?>
    		</p>
    		
    		<h4 style="color: #996800; margin: 20px 0 10px 0;">
    			<?php 
        esc_html_e( 'Want to do more? Upgrade to unlock premium features:', 'wpsummarize' );
        ?>
    		</h4>
    		
    		<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px; margin: 20px 0;">
    			<?php 
        foreach ( $features as $feature ) {
            ?>
    				<div style="background: #fff; padding: 15px; border-radius: 4px; border-left: 3px solid #2271b1;">
    					<strong style="color: #2271b1;">
    						<span class="dashicons <?php 
            echo esc_attr( $feature['icon'] );
            ?>" style="vertical-align: middle;"></span>
    						<?php 
            echo esc_html( $feature['title'] );
            ?>
    					</strong>
    					<p style="margin: 8px 0 0 0; font-size: 13px; color: #646970;">
    						<?php 
            echo esc_html( $feature['description'] );
            ?>
    					</p>
    				</div>
    			<?php 
        }
        ?>
    		</div>
    		
    		<p style="font-size: 14px; line-height: 1.6; margin-top: 20px;">
    			<?php 
        esc_html_e( 'Stop manually summarizing one post at a time. Upgrade and let AI handle your entire content library.', 'wpsummarize' );
        ?>
    		</p>
    		
    		<p style="margin-top: 20px;">
    			<a href="<?php 
        echo esc_url( wpsummarize_fs()->get_upgrade_url() );
        ?>" class="button button-primary button-hero" style="text-decoration: none;">
    				<span class="dashicons dashicons-cart" style="vertical-align: middle;"></span>
    				<?php 
        esc_html_e( 'See Plans &amp; Pricing', 'wpsummarize' );
        ?>
    			</a>
    		</p>
    	</div>
    	<?php 
    }
}

function wpsummarize_settings_page() {
    wpsummarize_display_user_message();
    ?>
    <div class="wrap wpsummarize_settings_form">
        <h2 class="wpsummarize_settings_title"><?php 
    echo esc_html__( 'WPSummarize Settings', 'wpsummarize' );
    ?></h2>
        
        <!-- Begin Form -->
        <form method="post" action="options.php">
            <?php 
    wpsummarize_check_and_notify_token_limit();
    settings_fields( 'wpsummarize_options' );
    // Unified option group
    do_settings_sections( 'wpsummarize_options' );
    // Display all sections
    submit_button( esc_html__( 'Save Changes', 'wpsummarize' ) );
    ?>
        </form>
    </div>
    <?php 
}

function wpsummarize_dashboard_page() {
    global $wpdb;
    wpsummarize_display_user_message();
    ?>
    <div class="wrap wpsummarize_settings_form">
        <h2 class="wpsummarize_settings_title"><?php 
    echo esc_html__( 'WPSummarize Dashboard', 'wpsummarize' );
    ?></h2>
        <?php 
    wpsummarize_check_and_notify_token_limit();
    $tokens_data = wpsummarize_api_check_tokens( 'dashboard' );
    $tokens_text = sprintf( 
        // translators: %1$d is the number of credits used, %2$d is the total number of credits available for the month
        esc_html__( 'Credits used this month: %1$s / %2$s', 'wpsummarize' ),
        esc_html( $tokens_data['tokens_used_month'] ),
        esc_html( $tokens_data['token_limit'] )
     );
    $allowed_html = array(
        'div'  => array(
            'class' => array(),
            'id'    => array(),
        ),
        'span' => array(
            'class' => array(),
        ),
    );
    echo wp_kses( '<div class="wpsummarize_dashboard_tokens">' . $tokens_text . '</div>', $allowed_html );
    echo '<table class="wp-list-table widefat fixed bookmarks" style="padding-left:0">
        <thead>
        <tr>
            <th><strong>' . esc_html__( 'Today', 'wpsummarize' ) . '</strong></th>
            <th><strong>' . esc_html__( 'Yesterday', 'wpsummarize' ) . '</strong></th>
            <th><strong>' . esc_html__( 'This Week', 'wpsummarize' ) . '</strong></th>
            <th><strong>' . esc_html__( 'This Month', 'wpsummarize' ) . '</strong></th>
            <th><strong>' . esc_html__( 'All Time', 'wpsummarize' ) . '</strong></th>        
        </tr>
    <thead>
     <tbody>
                        <tr>
                    <td>' . esc_html( $tokens_data['tokens_used_today'] ) . '</td>
                    <td>' . esc_html( $tokens_data['tokens_used_yesterday'] ) . '</td>
                    <td>' . esc_html( $tokens_data['tokens_used_week'] ) . '</td>
                    <td>' . esc_html( $tokens_data['tokens_used_month'] ) . '</td>
                    <td>' . esc_html( $tokens_data['tokens_used_all_time'] ) . '</td>        
                </tr>

            
    </tbody>
</table>';
    ?>

<h2 class="wpsummarize_settings_title subtitle"><?php 
    echo esc_html__( 'Latest summaries', 'wpsummarize' );
    ?></h2>
        <?php 
    // Query to get the last 15 summaries from postmeta
    $summaries = $wpdb->get_results( $wpdb->prepare( "\r\n    SELECT post_id, meta_value AS summary\r\n    FROM {$wpdb->postmeta} \r\n    WHERE meta_key = %s\r\n    ORDER BY meta_id DESC\r\n    LIMIT %d\r\n", '_wpsummarize_summary_set', 15 ) );
    // Start table
    echo '<table class="wp-list-table widefat fixed bookmarks" style="padding-left:0;margin-top: 20px;">
<tr>
<th style="width:20%"><strong>' . esc_html__( 'Post', 'wpsummarize' ) . '</strong></th>
<th><strong>' . esc_html__( 'Summary', 'wpsummarize' ) . '</strong></th>
</tr>';
    // Loop through the summaries and display them
    foreach ( $summaries as $summary ) {
        $post = get_post( $summary->post_id );
        // Retrieve the post object based on post_id
        $link = get_permalink( $summary->post_id );
        echo '<tr>
    <td><a href="' . esc_url( $link ) . '">' . esc_html( $post->post_title ) . '</a></td>
    <td>' . wp_kses_post( $summary->summary ) . '</td>
    </tr>';
    }
    // Close table
    echo '</table>';
    ?>
    </div>    
        
    <?php 
}

// Ensure this hooks into the admin_menu
add_action( 'admin_menu', 'wpsummarize_admin_menu' );
function wpsummarize_sanitize_svg(  $svg  ) {
    $allowed_tags = array(
        'svg'  => array(
            'xmlns'   => array(),
            'viewbox' => array(),
            'fill'    => array(),
        ),
        'path' => array(
            'd' => array(),
        ),
    );
    return wp_kses( $svg, $allowed_tags );
}
