jQuery(document).ready(function($) {
    $(document).on('click', '.notice[id^="wpsummarize-"] .notice-dismiss', function() {
        var notice = $(this).closest('.notice');
        var noticeId = notice.data('notice-id');
        var nonce = notice.data('nonce');
        
        if (noticeId && nonce) {
            $.ajax({
                url: wpsummarizeAjax.ajaxurl,
                type: 'POST',
                data: {
                    action: 'wpsummarize_dismiss_notice',
                    notice_id: noticeId,
                    nonce: nonce
                },
                success: function(response) {
                    if (response.success) {
                        notice.fadeOut();
                    }
                },
                error: function() {
                    console.log('Error dismissing notice');
                }
            });
        }
    });
});