<?php
/** Don't load directly */
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'foxiz_register_options_color' ) ) {
	function foxiz_register_options_color() {

		return [
			'id'     => 'foxiz_config_section_color',
			'title'  => esc_html__( 'Global Colors', 'foxiz' ),
			'desc'   => esc_html__( 'Customize the website\'s colors.', 'foxiz' ),
			'icon'   => 'el el-tint',
			'fields' => [
				[
					'id'     => 'section_start_global_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Highlight Elements', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => 'global_color',
					'title'       => esc_html__( 'Global Highlight Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a global color. This setting applies to all links, menus, category overlays, main pages, and many contrasting elements.', 'foxiz' ),
					'description' => esc_html__( 'Recommend choosing a color that contrasts effectively with white text for optimal visibility.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'          => 'dark_global_color',
					'title'       => esc_html__( 'Dark Mode - Global Highlight Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a global color in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'     => 'section_end_global_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_accent_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Dark Accent', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => 'accent_color',
					'title'       => esc_html__( 'Dark Accent Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a dark accent color for your site, This setting apply to single header background, gradient colors.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'          => 'dark_accent_color',
					'title'       => esc_html__( 'Dark Mode - Dark Accent Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select dark accent color in dark mode.', 'foxiz' ),
					'description' => esc_html__( 'Recommend choosing a lighter color than the dark mode background to ensure these elements are clearly visible in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'     => 'section_end_accent_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_dark_bg_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Body Background', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => 'body_background',
					'title'       => esc_html__( 'Body Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a light solid background the website body. Leave blank to set it as the default.', 'foxiz' ),
					'description' => esc_html__( 'Recommend choosing a light background to ensure optimal text visibility in the default (light) mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'          => 's_body_background',
					'title'       => esc_html__( 'Body Background for Single Post', 'foxiz' ),
					'subtitle'    => esc_html__( 'Specify the body background color for single post pages.', 'foxiz' ),
					'description' => esc_html__( 'Defaults to the main body background setting if left blank.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'          => 'dark_background',
					'title'       => esc_html__( 'Dark Mode - Body Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a dark solid background for dark mode. Leave blank to set it as the default.', 'foxiz' ),
					'description' => esc_html__( 'In dark mode, the body background will also apply to single posts.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'     => 'section_end_dark_bg_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_button_colors',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Button', 'foxiz' ),
					'notice' => [
						esc_html__( 'The settings below will be useful if you want to apply a light background color and dark text to buttons.', 'foxiz' ),
						esc_html__( 'The following settings will affect all buttons site-wide in both default and dark modes.', 'foxiz' ),
					],
					'indent' => true,
				],
				[
					'id'          => 'btn_primary_color',
					'title'       => esc_html__( 'Primary Color (Background)', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a primary background color for the buttons.', 'foxiz' ),
					'description' => esc_html__( 'Leave blank to use the default color based on global colors settings.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'          => 'btn_accent_color',
					'title'       => esc_html__( 'Accent Color (Text)', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for the button text.', 'foxiz' ),
					'description' => esc_html__( 'Leave blank to use the default color (white).', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'          => 'btn_primary_hover_color',
					'title'       => esc_html__( 'Hover - Primary Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Set the background color for buttons when hovered.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'          => 'btn_accent_hover_color',
					'title'       => esc_html__( 'Hover - Accent Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Set the text color for buttons when hovered.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'     => 'section_end_button_colors',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_mode_switcher',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Mode Switcher', 'foxiz' ),
					'subtitle' => esc_html__( 'These settings below will apply to all dark/light mode switchers on the website.', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'          => 'light_switcher_color',
					'title'       => esc_html__( 'Light Switcher - Icon Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for for the sun icon.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'          => 'light_switcher_bg',
					'title'       => esc_html__( 'Light Switcher - Icon Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background for the sun icon.', 'foxiz' ),
					'description' => esc_html__( 'Background settings will not be applied when using the Minimalistic switch style.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'          => 'light_switcher_slide',
					'title'       => esc_html__( 'Light Switcher - Slide Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background for the slider in light mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'          => 'dark_switcher_color',
					'title'       => esc_html__( 'Dark Switcher - Icon Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for for the moon icon.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'          => 'dark_switcher_bg',
					'title'       => esc_html__( 'Dark Switcher - Icon Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background for the moon icon.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'          => 'dark_switcher_slide',
					'title'       => esc_html__( 'Dark Switcher - Slide Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background for the slider in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'     => 'section_end_mode_switcher',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_bookmark_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Bookmark Hovering', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => 'bookmark_color',
					'title'       => esc_html__( 'Bookmark Hover Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color value when hovering on the bookmark.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'          => 'dark_bookmark_color',
					'title'       => esc_html__( 'Dark Mode - Bookmark Hover Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color value when hovering on the bookmark in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'     => 'section_end_bookmark_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_review_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Review Stars', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => 'review_color',
					'title'       => esc_html__( 'Background Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a primary background color for the review star icon.', 'foxiz' ),
					'description' => esc_html__( 'The default background color is #ffc300.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'          => 'review_icon_color',
					'title'       => esc_html__( 'Icon Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for the review star icon.', 'foxiz' ),
					'description' => esc_html__( 'The default color is white.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'          => 'dark_review_color',
					'title'       => esc_html__( 'Dark Mode - Background Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a primary background color for review star icon in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'          => 'dark_review_icon_color',
					'title'       => esc_html__( 'Dark Mode - Icon Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select an icon color for review star icon in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'     => 'section_end_review_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_sponsor_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Sponsor Label', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => 'sponsor_color',
					'title'       => esc_html__( 'Sponsor Label Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color value for the sponsor label.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'          => 'dark_sponsor_color',
					'title'       => esc_html__( 'Dark Mode - Sponsor Label Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color value for the sponsor label in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'     => 'section_end_sponsor_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_counter_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Popular Counter', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => 'counter_color',
					'title'       => esc_html__( 'Popular Counter Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for the counter elements.', 'foxiz' ),
					'description' => esc_html__( 'Transparent color is recommended.', 'foxiz' ),
					'type'        => 'color_rgba',
				],
				[
					'id'       => 'dark_counter_color',
					'title'    => esc_html__( 'Dark Mode - Popular Counter Color', 'foxiz' ),
					'subtitle' => esc_html__( 'Select a color for the counter elements in dark mode.', 'foxiz' ),
					'type'     => 'color_rgba',
				],
				[
					'id'     => 'section_end_counter_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_live_blog_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Live Blogging', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => 'live_blog_color',
					'title'       => esc_html__( 'Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for the live blogging icons.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'          => 'dark_live_blog_color',
					'title'       => esc_html__( 'Dark Mode - Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for the live blogging icons in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'     => 'section_end_live_blog_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_toc_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'TOC, Left Shares & Inline Related', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => 'toc_bg',
					'title'       => esc_html__( 'Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background color for the table of contents, left share section, and inline related section.', 'foxiz' ),
					'description' => esc_html__( 'Recommend choosing a light background to ensure optimal text visibility in the default (light) mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'          => 'dark_toc_bg',
					'title'       => esc_html__( 'Dark Mode - Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background color for the table of contents, left share section, and inline related section in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				],
				[
					'id'     => 'section_end_toc_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'     => 'section_start_tick_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Verified Tick Color', 'foxiz' ),
					'indent' => true,
				],
				[
					'id'          => 'author_tick_color',
					'title'       => esc_html__( 'Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Choose a color for the Verified Tick that will appear next to the author name.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'          => 'dark_author_tick_color',
					'title'       => esc_html__( 'Dark Mode - Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Choose a color for the Verified Tick that will appear next to the author name in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'     => 'section_end_tick_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],
				[
					'id'       => 'section_start_input_focus_color',
					'type'     => 'section',
					'class'    => 'ruby-section-start',
					'title'    => esc_html__( 'Input Focus Border', 'foxiz' ),
					'subtitle' => esc_html__( 'To configure the style for input fields, please navigate to "Theme Design > Input Style".', 'foxiz' ),
					'indent'   => true,
				],
				[
					'id'          => 'input_focus_color',
					'title'       => esc_html__( 'Focus Border Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Choose a border color when typing in the input field.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				],
				[
					'id'     => 'section_end_input_focus_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false,
				],

			],
		];
	}
}
