<?php
/**
 * New custom code snippet (replace this with snippet description).
 */

toolset_snippet_security_check() or die( 'Direct access is not allowed' );
// Initialize Form 6 summarizer

function get_form6_summarizer() {
    static $summarizer = null;
    
    if ($summarizer === null) {
        $api_key = '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';
        if (empty($api_key)) {
            return new WP_Error('missing_api_key', 'DeepSeek API key not configured');
        }
        $summarizer = new Form6DeepSeekSummarizer($api_key);
    }
    
    return $summarizer;
}

// Process new Form 6 submissions automatically
add_action('gform_after_submission_6', 'process_form6_submission', 10, 2);

function process_form6_submission($entry, $form) {
    $summarizer = get_form6_summarizer();
    
    if (is_wp_error($summarizer)) {
        error_log('Form 6 summarizer error: ' . $summarizer->get_error_message());
        return;
    }
    
    try {
        $summary = $summarizer->processSingleSubmission($entry);
        
        if ($summary) {
            // Store summary in entry meta
            gform_update_meta($entry['id'], 'deepseek_summary', $summary);
            gform_update_meta($entry['id'], 'deepseek_summary_generated', current_time('mysql'));
            
            error_log("DeepSeek summary generated for Form 6 entry {$entry['id']}");
            
            // Send notification
            send_form6_summary_notification($entry, $summary);
        }
        
    } catch (Exception $e) {
        error_log('Form 6 summary generation failed: ' . $e->getMessage());
        gform_update_meta($entry['id'], 'deepseek_summary_error', $e->getMessage());
    }
}

// Send notification for Form 6 summaries
function send_form6_summary_notification($entry, $summary) {
    $to = get_option('admin_email'); // or specific email
    $subject = 'DeepSeek Summary - Form 6 Submission #' . $entry['id'];
    
    $message = "
    New Form 6 Submission Summary

    Entry ID: {$entry['id']}
    Date: " . date('F j, Y g:i A', strtotime($entry['date_created'])) . "

    ====================
    DEEPSEEK AI SUMMARY
    ====================

    {$summary}

    ====================

    View full entry: " . admin_url("admin.php?page=gf_entries&view=entry&id=6&lid={$entry['id']}") . "

    ---
    Generated automatically by DeepSeek AI
    ";
    
    wp_mail($to, $subject, $message);
}
// Put the code of your snippet below this comment.