<?php
/**
 * New custom code snippet (replace this with snippet description).
 */

toolset_snippet_security_check() or die( 'Direct access is not allowed' );
// Add DeepSeek summary to Form 6 entry details
add_action('gform_entry_detail_content_before', 'display_form6_deepseek_summary', 10, 2);

function display_form6_deepseek_summary($form, $entry) {
    if ($form['id'] != 6) return;
    
    $summary = gform_get_meta($entry['id'], 'deepseek_summary');
    
    if ($summary) {
        $generated_time = gform_get_meta($entry['id'], 'deepseek_summary_generated');
        
        echo "
        <div class='form6-deepseek-summary' style='
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px; 
            margin: 20px 0; 
            border-radius: 8px;
            color: white;
        '>
            <h3 style='margin-top: 0; color: white;'>
                🚀 Form 6 - DeepSeek AI Summary
            </h3>
            " . ($generated_time ? "<p style='color: rgba(255,255,255,0.8); font-size: 12px; margin: 0;'>Generated: " . date('F j, Y g:i A', strtotime($generated_time)) . "</p>" : "") . "
            <div style='
                background: rgba(255,255,255,0.95); 
                padding: 20px; 
                border-radius: 6px; 
                margin-top: 15px;
                color: #333;
                white-space: pre-wrap;
                line-height: 1.6;
                border: 1px solid rgba(255,255,255,0.2);
                max-height: 500px;
                overflow-y: auto;
            '>
                " . nl2br(esc_html($summary)) . "
            </div>
        </div>
        ";
    } else {
        // Show generate button if no summary exists
        echo "
        <div class='form6-generate-summary' style='
            background: #f0f0f1;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
            border-left: 4px solid #007cba;
        '>
            <h4 style='margin-top: 0;'>Generate DeepSeek AI Summary</h4>
            <p>No AI summary exists for this entry. Generate one using DeepSeek API.</p>
            <button type='button' class='button button-primary' onclick='generateForm6Summary({$entry['id']})'>
                Generate AI Summary
            </button>
            <span id='form6-summary-status' style='margin-left: 10px;'></span>
        </div>
        
        <script>
        function generateForm6Summary(entryId) {
            const statusEl = document.getElementById('form6-summary-status');
            statusEl.innerHTML = 'Generating...';
            
            fetch('" . admin_url('admin-ajax.php') . "', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: 'action=generate_form6_summary&entry_id=' + entryId
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    statusEl.innerHTML = '✓ Summary generated! Refreshing...';
                    setTimeout(() => location.reload(), 2000);
                } else {
                    statusEl.innerHTML = '✗ Error: ' + data.data;
                }
            })
            .catch(error => {
                statusEl.innerHTML = '✗ Request failed';
            });
        }
        </script>
        ";
    }
}

// AJAX handler for manual summary generation
add_action('wp_ajax_generate_form6_summary', 'ajax_generate_form6_summary');

function ajax_generate_form6_summary() {
    if (!current_user_can('manage_options')) {
        wp_die('Unauthorized');
    }
    
    $entry_id = intval($_POST['entry_id']);
    $summarizer = get_form6_summarizer();
    
    if (is_wp_error($summarizer)) {
        wp_send_json_error($summarizer->get_error_message());
    }
    
    $entry = GFAPI::get_entry($entry_id);
    if (is_wp_error($entry)) {
        wp_send_json_error('Entry not found');
    }
    
    if ($entry['form_id'] != 6) {
        wp_send_json_error('Entry is not from Form 6');
    }
    
    $summary = $summarizer->processSingleSubmission($entry);
    
    if ($summary) {
        gform_update_meta($entry_id, 'deepseek_summary', $summary);
        gform_update_meta($entry_id, 'deepseek_summary_generated', current_time('mysql'));
        wp_send_json_success('Summary generated successfully');
    } else {
        wp_send_json_error('Failed to generate summary');
    }
}
// Put the code of your snippet below this comment.