<?php
/**
 * New custom code snippet (replace this with snippet description).
 */

toolset_snippet_security_check() or die( 'Direct access is not allowed' );
// Add admin page for bulk processing Form 6 entries
add_action('admin_menu', 'add_form6_bulk_processing_page');

function add_form6_bulk_processing_page() {
    add_submenu_page(
        'gf_edit_forms',
        'Form 6 Bulk Processing',
        'Form 6 Bulk AI Summary',
        'manage_options',
        'form6-bulk-processing',
        'form6_bulk_processing_page'
    );
}

function form6_bulk_processing_page() {
    $summarizer = get_form6_summarizer();
    $entries = GFAPI::get_entries(6);
    $processed_count = 0;
    
    // Process bulk action
    if (isset($_POST['bulk_process_form6']) && check_admin_referer('form6_bulk_process')) {
        $entry_ids = $_POST['entry_ids'] ?? [];
        
        echo '<div class="notice notice-info"><p>Processing ' . count($entry_ids) . ' entries...</p></div>';
        
        foreach ($entry_ids as $entry_id) {
            $entry = GFAPI::get_entry($entry_id);
            if (!is_wp_error($entry)) {
                $summary = $summarizer->processSingleSubmission($entry);
                if ($summary) {
                    gform_update_meta($entry_id, 'deepseek_summary', $summary);
                    gform_update_meta($entry_id, 'deepseek_summary_generated', current_time('mysql'));
                    $processed_count++;
                    echo '<div class="notice notice-success inline"><p>Processed entry #' . $entry_id . '</p></div>';
                }
            }
        }
        
        echo '<div class="notice notice-success"><p>Completed! Processed ' . $processed_count . ' entries.</p></div>';
    }
    
    ?>
    <div class="wrap">
        <h1>Form 6 - Bulk AI Summary Generation</h1>
        
        <div class="card">
            <h2>Process Existing Entries</h2>
            <p>Select Form 6 entries to generate AI summaries using DeepSeek API.</p>
            
            <form method="post">
                <?php wp_nonce_field('form6_bulk_process'); ?>
                
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th style="width: 20px;"><input type="checkbox" id="select-all"></th>
                            <th>Entry ID</th>
                            <th>Date</th>
                            <th>Current Status</th>
                            <th>PDF Files</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($entries as $entry): 
                            $has_summary = !empty(gform_get_meta($entry['id'], 'deepseek_summary'));
                            $pdf_count = $this->countPDFFiles($entry);
                        ?>
                        <tr>
                            <td><input type="checkbox" name="entry_ids[]" value="<?php echo $entry['id']; ?>"></td>
                            <td><?php echo $entry['id']; ?></td>
                            <td><?php echo date('M j, Y g:i A', strtotime($entry['date_created'])); ?></td>
                            <td>
                                <?php if ($has_summary): ?>
                                    <span style="color: green;">✓ Has AI Summary</span>
                                <?php else: ?>
                                    <span style="color: orange;">No Summary</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo $pdf_count; ?> PDF(s)</td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                
                <p style="margin-top: 20px;">
                    <button type="submit" name="bulk_process_form6" class="button button-primary">
                        Generate AI Summaries for Selected Entries
                    </button>
                </p>
            </form>
        </div>
    </div>
    
    <script>
    jQuery(document).ready(function($) {
        $('#select-all').change(function() {
            $('input[name="entry_ids[]"]').prop('checked', this.checked);
        });
    });
    </script>
 
}

// Helper function to count PDF files in entry
private function countPDFFiles($entry) {
    $form = GFAPI::get_form(6);
    $count = 0;
    
    foreach ($form['fields'] as $field) {
        if ($field->type === 'fileupload') {
            $file_urls = rgar($entry, $field->id);
            if (!empty($file_urls)) {
                $urls = json_decode($file_urls);
                if (!$urls) $urls = [$file_urls];
                
                foreach ($urls as $url) {
                    if (pathinfo($url, PATHINFO_EXTENSION) === 'pdf') {
                        $count++;
                    }
                }
            }
        }
    }
    
    return $count;
}
?>