<?php
/**
 * New custom code snippet (replace this with snippet description).
 */

toolset_snippet_security_check() or die( 'Direct access is not allowed' );
// Enqueue necessary scripts and styles
function multistep_cred_scripts() {
    wp_enqueue_script('jquery');
    wp_enqueue_script('multistep-cred', 'https://clicknetco.com/afdech/multistep-cred.js', array('jquery'), '1.0', true);
    wp_enqueue_style('multistep-cred', 'https://clicknetco.com/afdech/multistep-cred.css');
}
add_action('wp_enqueue_scripts', 'multistep_cred_scripts');

// Shortcode to wrap CRED form in multi-step structure
function multistep_cred_form_shortcode($atts, $content = null) {
    $atts = shortcode_atts(array(
        'form_id' => '',
        'steps' => 9
    ), $atts);
    
    ob_start();
    ?>
    <div class="multistep-cred-container" data-steps="<?php echo esc_attr($atts['steps']); ?>">
        <!-- Progress Bar -->
        <div class="multistep-progress">
            <div class="progress-bar">
                <div class="progress-fill" style="width: 11.11%;"></div>
            </div>
            <div class="progress-steps">
                <?php for ($i = 1; $i <= $atts['steps']; $i++): ?>
                    <div class="progress-step <?php echo $i === 1 ? 'active' : ''; ?>" data-step="<?php echo $i; ?>">
                        <span class="step-number"><?php echo $i; ?></span>
                        <span class="step-label">Step <?php echo $i; ?></span>
                    </div>
                <?php endfor; ?>
            </div>
        </div>
        
        <!-- Form Steps -->
        <div class="multistep-form">
            <?php echo do_shortcode($content); ?>
        </div>
        
        <!-- Navigation Buttons -->
        <div class="multistep-navigation">
            <button type="button" class="nav-btn prev-btn" style="display: none;">
                < Previous
            </button>
            <button type="button" class="nav-btn next-btn">
                Next >
            </button>
            <button type="submit" class="nav-btn submit-btn" style="display: none;">
                Publish
            </button>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('multistep_cred', 'multistep_cred_form_shortcode');

// Function to split CRED form into steps
function split_cred_into_steps($form_content) {
    // This function helps organize your form fields into steps
    // You'll need to modify your CRED form to use this structure
    return $form_content;
}

// Put the code of your snippet below this comment.