<?php
/**
 * New custom code snippet (replace this with snippet description).
 */

toolset_snippet_security_check() or die( 'Direct access is not allowed' );

// Enqueue necessary scripts and styles
function dynamic_multistep_cred_scripts() {
    wp_enqueue_script('jquery');
    wp_enqueue_script('dynamic-multistep-cred', 'https://clicknetco.com/afdech/dynamic-multistep-cred.js', array('jquery'), '1.0', true);
    wp_enqueue_style('dynamic-multistep-cred', 'https://clicknetco.com/afdech/dynamic-multistep-cred.css');
  
add_action('wp_enqueue_scripts', 'dynamic_multistep_cred_scripts');

// Main shortcode for dynamic multi-step CRED form
function dynamic_multistep_cred_shortcode($atts) {
    $atts = shortcode_atts(array(
        'form_id' => '537',
        'post_type' => 'project'
    ), $atts);
    
    // Get field groups
    $field_groups = get_project_field_groups($atts['post_type']);
    $total_steps = count($field_groups);
    
    if ($total_steps === 0) {
        return '<p>No field groups found for post type: ' . esc_html($atts['post_type']) . '</p>';
    }
    
    ob_start();
    ?>
    <div class="dynamic-multistep-cred-container" 
         data-form-id="<?php echo esc_attr($atts['form_id']); ?>"
         data-post-type="<?php echo esc_attr($atts['post_type']); ?>"
         data-total-steps="<?php echo esc_attr($total_steps); ?>">
        
        <!-- Progress Bar -->
        <div class="multistep-progress">
            <div class="progress-bar">
                <div class="progress-fill" style="width: <?php echo (100/$total_steps); ?>%;"></div>
            </div>
            <div class="progress-steps">
                <?php foreach ($field_groups as $index => $group): ?>
                    <div class="progress-step <?php echo $index === 0 ? 'active' : ''; ?>" 
                         data-step="<?php echo $index + 1; ?>"
                         data-group-slug="<?php echo esc_attr($group['slug']); ?>">
                        <span class="step-number"><?php echo $index + 1; ?></span>
                        <span class="step-label"><?php echo esc_html($group['name']); ?></span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <!-- Form Container -->
        <div class="multistep-form-wrapper">
            <?php 
            // Output the CRED form first
            $cred_form = do_shortcode('[cred_form form="' . $atts['form_id'] . '"]');
            
            // If CRED form is empty, show a message
            if (empty($cred_form)) {
                echo '<div class="cred-form-missing">';
                echo '<p>CRED form not found or no output. Please check:</p>';
                echo '<ul>';
                echo '<li>Is the CRED form ID ' . esc_html($atts['form_id']) . ' correct?</li>';
                echo '<li>Is Toolset CRED active?</li>';
                echo '<li>Does the form have fields?</li>';
                echo '</ul>';
                echo '</div>';
                return ob_get_clean();
            }
            
            // Wrap the CRED form in our multi-step structure
            ?>
            <form class="multistep-cred-form" id="multistep-form-<?php echo esc_attr($atts['form_id']); ?>">
                <?php 
                // Split the CRED form into steps based on field groups
                echo split_cred_form_into_steps($cred_form, $field_groups, $total_steps);
                ?>
                
                <!-- Navigation Buttons -->
                <div class="multistep-navigation">
                    <button type="button" class="nav-btn prev-btn" style="display: none;">
                        < Previous
                    </button>
                    <button type="button" class="nav-btn next-btn">
                        Next >
                    </button>
                    <input type="submit" class="nav-btn submit-btn" style="display: none;" value="Publish Project">
                </div>
            </form>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('dynamic_multistep_cred', 'dynamic_multistep_cred_shortcode');

// Function to get field groups for project post type
function get_project_field_groups($post_type = 'project') {
    $field_groups = array();
    
    // Try different methods to get field groups
    if (function_exists('wpcf_admin_get_groups_by_post_type')) {
        // Toolset method
        $groups = wpcf_admin_get_groups_by_post_type($post_type);
        foreach ($groups as $group_id => $group) {
            if ($group['is_active']) {
                $field_groups[] = array(
                    'id' => $group_id,
                    'name' => $group['name'],
                    'slug' => $group['slug'],
                    'fields' => isset($group['fields']) ? $group['fields'] : array()
                );
            }
        }
    } 
    elseif (function_exists('types_get_field_groups')) {
        // Types method
        $groups = types_get_field_groups(array('post_type' => $post_type));
        foreach ($groups as $group) {
            $field_groups[] = array(
                'id' => $group['id'],
                'name' => $group['name'],
                'slug' => $group['slug'],
                'fields' => isset($group['fields']) ? $group['fields'] : array()
            );
        }
    }
    else {
        // Fallback - create dummy groups for testing
        $field_groups = array(
            array(
                'id' => 'basic_info',
                'name' => 'Basic Information',
                'slug' => 'basic-information',
                'fields' => array()
            ),
            array(
                'id' => 'project_details',
                'name' => 'Project Details', 
                'slug' => 'project-details',
                'fields' => array()
            ),
            array(
                'id' => 'additional_info',
                'name' => 'Additional Information',
                'slug' => 'additional-information', 
                'fields' => array()
            )
        );
    }
    
    return $field_groups;
}

// Function to split CRED form into steps
function split_cred_form_into_steps($cred_form, $field_groups, $total_steps) {
    $output = '';
    
    // If we can't detect fields properly, show the form in steps with manual grouping
    if (empty($field_groups) {
        return $cred_form;
    }
    
    // Create step containers
    for ($i = 1; $i <= $total_steps; $i++) {
        $group = $field_groups[$i - 1];
        $active_class = $i === 1 ? 'active' : '';
        
        $output .= '<div class="form-step ' . $active_class . '" data-step="' . $i . '" data-group-slug="' . esc_attr($group['slug']) . '">';
        $output .= '<div class="step-header">';
        $output .= '<h3>' . esc_html($group['name']) . '</h3>';
        $output .= '<p>Step ' . $i . ' of ' . $total_steps . '</p>';
        $output .= '</div>';
        
        $output .= '<div class="step-content">';
        
        // For the first step, show the form title and basic fields
        if ($i === 1) {
            $output .= extract_basic_fields($cred_form);
        }
        // For other steps, we'll need to map fields to steps
        else {
            $output .= '<div class="field-group-placeholder">';
            $output .= '<h4>' . esc_html($group['name']) . ' Fields</h4>';
            $output .= '<p>Fields for this section will be shown here.</p>';
            $output .= '<div class="manual-field-mapping">';
            $output .= '<p><strong>Group Slug:</strong> ' . esc_html($group['slug']) . '</p>';
            $output .= '<p>Map your CRED form fields to this group using the slug above.</p>';
            $output .= '</div>';
            $output .= '</div>';
        }
        
        $output .= '</div>';
        $output .= '</div>';
    }
    
    return $output;
}

// Function to extract basic fields from CRED form
function extract_basic_fields($cred_form) {
    // Try to extract the post title and content fields
    $basic_fields = '';
    
    // Look for post title field
    if (preg_match('/<input[^>]*name="post_title[^>]*>/', $cred_form, $matches)) {
        $basic_fields .= '<div class="form-field">';
        $basic_fields .= '<label for="post_title">Project Title</label>';
        $basic_fields .= $matches[0];
        $basic_fields .= '</div>';
    }
    
    // Look for post content field
    if (preg_match('/<textarea[^>]*name="post_content[^>]*>.*?<\/textarea>/s', $cred_form, $matches)) {
        $basic_fields .= '<div class="form-field">';
        $basic_fields .= '<label for="post_content">Project Description</label>';
        $basic_fields .= $matches[0];
        $basic_fields .= '</div>';
    }
    
    // If no specific fields found, show the entire form for first step
    if (empty($basic_fields)) {
        $basic_fields = $cred_form;
    }
    
    return $basic_fields;
}

// Alternative shortcode for manual field assignment
function manual_multistep_cred_shortcode($atts) {
    $atts = shortcode_atts(array(
        'form_id' => '537',
        'steps' => '3'
    ), $atts);
    
    ob_start();
    ?>
    <div class="manual-multistep-cred-container" data-form-id="<?php echo esc_attr($atts['form_id']); ?>" data-steps="<?php echo esc_attr($atts['steps']); ?>">
        <!-- Progress Bar -->
        <div class="multistep-progress">
            <div class="progress-bar">
                <div class="progress-fill" style="width: <?php echo (100/intval($atts['steps'])); ?>%;"></div>
            </div>
            <div class="progress-steps">
                <?php for ($i = 1; $i <= intval($atts['steps']); $i++): ?>
                    <div class="progress-step <?php echo $i === 1 ? 'active' : ''; ?>" data-step="<?php echo $i; ?>">
                        <span class="step-number"><?php echo $i; ?></span>
                        <span class="step-label">Step <?php echo $i; ?></span>
                    </div>
                <?php endfor; ?>
            </div>
        </div>
        
        <!-- Form Container -->
        <div class="multistep-form-wrapper">
            <?php 
            $cred_form = do_shortcode('[cred_form form="' . $atts['form_id'] . '"]');
            if ($cred_form) {
                echo $cred_form;
            } else {
                echo '<p>CRED form not found. Please check the form ID.</p>';
            }
            ?>
            
            <!-- Navigation will be added by JavaScript -->
        </div>
        
        <!-- Navigation Buttons -->
        <div class="multistep-navigation">
            <button type="button" class="nav-btn prev-btn" style="display: none;">
                < Previous
            </button>
            <button type="button" class="nav-btn next-btn">
                Next >
            </button>
            <input type="submit" class="nav-btn submit-btn" style="display: none;" value="Publish Project">
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('manual_multistep_cred', 'manual_multistep_cred_shortcode');

// Debug function to check what's available
function debug_field_groups() {
    $field_groups = get_project_field_groups('project');
    echo '<pre>';
    print_r($field_groups);
    echo '</pre>';
}
// add_action('wp_footer', 'debug_field_groups'); // Uncomment to debug