
    jQuery(document).ready(function($) {
        // Generate AI Summary
        $(document).on("click", "#generate-ai-summary", function(e) {
            e.preventDefault();
            
            var button = $(this);
            var entryId = button.data("entry-id");
            var formId = button.data("form-id");
            var statusEl = $("#ai-summary-status");
            
            button.prop("disabled", true).html('<span class="dashicons dashicons-update spin"></span> Generating...');
            statusEl.removeClass("success error").addClass("loading").text(gf_ai_summary.generating_text);
            
            $.ajax({
                url: gf_ai_summary.ajax_url,
                type: "POST",
                data: {
                    action: "gf_generate_ai_summary",
                    nonce: gf_ai_summary.nonce,
                    entry_id: entryId,
                    form_id: formId
                },
                success: function(response) {
                    if (response.success) {
                        statusEl.removeClass("loading").addClass("success").text(gf_ai_summary.success_text);
                        
                        // Display preview
                        $("#ai-summary-preview").show();
                        $("#summary-content").html(response.data.summary.replace(/\n/g, "<br>"));
                        
                        // Show save button
                        $("#save-ai-summary").show().data("summary", response.data.summary);
                    } else {
                        statusEl.removeClass("loading").addClass("error").text(response.data || gf_ai_summary.error_text);
                    }
                },
                error: function() {
                    statusEl.removeClass("loading").addClass("error").text(gf_ai_summary.error_text);
                },
                complete: function() {
                    button.prop("disabled", false).html('<span class="dashicons dashicons-robot"></span> Generate AI Summary');
                }
            });
        });
        
        // Save AI Summary
        $(document).on("click", "#save-ai-summary", function(e) {
            e.preventDefault();
            
            var button = $(this);
            var entryId = button.data("entry-id");
            var summary = button.data("summary");
            var statusEl = $("#ai-summary-status");
            
            button.prop("disabled", true).text("Saving...");
            statusEl.removeClass("success error").addClass("loading").text(gf_ai_summary.saving_text);
            
            $.ajax({
                url: gf_ai_summary.ajax_url,
                type: "POST",
                data: {
                    action: "gf_save_ai_summary",
                    nonce: gf_ai_summary.nonce,
                    entry_id: entryId,
                    summary: summary
                },
                success: function(response) {
                    if (response.success) {
                        statusEl.removeClass("loading").addClass("success").text(gf_ai_summary.saved_text);
                        button.hide();
                        
                        // Reload the page to show new summary in meta box
                        setTimeout(function() {
                            location.reload();
                        }, 2000);
                    } else {
                        statusEl.removeClass("loading").addClass("error").text(response.data || "Error saving summary");
                    }
                },
                error: function() {
                    statusEl.removeClass("loading").addClass("error").text("Error saving summary");
                },
                complete: function() {
                    button.prop("disabled", false).text("Save Summary to Entry");
                }
            });
        });
    });
    