<?php
/**
 * New custom code snippet (replace this with snippet description).
 */

toolset_snippet_security_check() or die( 'Direct access is not allowed' );

// Auto-generate AI Summary on Form Submission from Fields and PDF Attachments
// Includes built-in PDF text extraction

// 1. Add the button to admin entry page
add_action('admin_init', 'add_ai_summary_button_to_entry_page');
function add_ai_summary_button_to_entry_page() {
    if (isset($_GET['page']) && $_GET['page'] === 'gf_entries' && isset($_GET['lid'])) {
        add_action('admin_footer', 'add_ai_summary_button_html');
    }
}

// 2. Add the button HTML and JavaScript
function add_ai_summary_button_html() {
    if (!isset($_GET['id']) || !isset($_GET['lid'])) return;
    
    $form_id = intval($_GET['id']);
    $entry_id = intval($_GET['lid']);
    ?>
    <style>
        .gf-ai-summary-button-container {
            margin: 15px 0;
            padding: 10px;
            background: #fff;
            border: 1px solid #ccd0d4;
            box-shadow: 0 1px 1px rgba(0,0,0,.04);
        }
        
        #gf-ai-summary-btn {
            background: #2271b1;
            border-color: #2271b1;
            color: #fff;
            text-decoration: none;
            text-shadow: none;
            display: inline-flex;
            align-items: center;
        }
        
        #ai-summary-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            z-index: 99999;
        }
        
        #ai-summary-content {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            background: white;
            padding: 20px;
            border-radius: 5px;
            width: 700px;
            max-width: 90%;
            max-height: 80vh;
            overflow-y: auto;
        }
        
        .summary-length-info {
            background: #f0f9ff;
            padding: 10px;
            margin: 10px 0;
            border-radius: 4px;
            border-left: 4px solid #2271b1;
        }
    </style>

    <div class="gf-ai-summary-button-container">
        <button type="button" id="gf-ai-summary-btn" class="button">
            <span class="dashicons dashicons-format-chat"></span>
            Generate AI Summary
        </button>
        <span style="margin-left: 10px; color: #666; font-size: 13px;">
            Generate comprehensive summary from form fields and PDF attachments (Fields 67, 90)
        </span>
    </div>

    <div id="ai-summary-modal">
        <div id="ai-summary-content">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 15px;">
                <h3 style="margin: 0;">AI Summary Generator</h3>
                <button onclick="closeAISummary()" style="background:none;border:none;font-size:24px;cursor:pointer;">×</button>
            </div>
            
            <p><strong>Form ID:</strong> <?php echo $form_id; ?> | <strong>Entry ID:</strong> <?php echo $entry_id; ?></p>
            <p><small>Summary will be saved to field ID: <strong>103</strong> (800-900 words with H3 headings)</small></p>
            
            <div class="summary-length-info">
                <p><strong>Summary will include:</strong></p>
                <ul style="margin: 5px 0 5px 20px;">
                    <li>All form field values</li>
                    <li>PDF content from fields ID 67 and 90</li>
                    <li>800-900 word comprehensive summary</li>
                    <li>H3 headings for organization</li>
                    <li>Clear paragraph structure</li>
                </ul>
            </div>
            
            <div style="margin: 15px 0;">
                <label style="display:block; margin-bottom:5px;"><strong>Focus Areas (optional):</strong></label>
                <textarea id="ai-custom-prompt" style="width:100%; height:80px; margin:5px 0;" 
                    placeholder="e.g., 'Focus on financial information, highlight key dates, summarize main findings from documents...'"></textarea>
            </div>
            
            <button id="generate-summary-btn" class="button button-primary" onclick="callAIAPI(<?php echo $form_id; ?>, <?php echo $entry_id; ?>)">
                <span class="dashicons dashicons-format-chat" style="vertical-align:middle; margin-right:5px;"></span>
                Generate Comprehensive Summary
            </button>
            
            <button class="button" onclick="closeAISummary()" style="margin-left:10px;">Cancel</button>
            
            <div id="ai-summary-result" style="margin-top: 20px;"></div>
        </div>
    </div>

    <script>
    let currentSummary = '';
    
    jQuery(document).ready(function($) {
        $('#gf-ai-summary-btn').on('click', function() {
            $('#ai-summary-modal').show();
            $('#ai-summary-result').html('');
        });
    });
    
    function closeAISummary() {
        jQuery('#ai-summary-modal').hide();
        jQuery('#ai-summary-result').html('');
        jQuery('#ai-custom-prompt').val('');
        jQuery('#generate-summary-btn').prop('disabled', false);
        currentSummary = '';
    }
    
    function callAIAPI(formId, entryId) {
        var customPrompt = jQuery('#ai-custom-prompt').val();
        var button = jQuery('#generate-summary-btn');
        var resultDiv = jQuery('#ai-summary-result');
        
        button.prop('disabled', true);
        resultDiv.html('<div style="text-align:center; padding:20px;"><span class="spinner is-active" style="float:none; margin:0 10px 0 0;"></span> Generating comprehensive summary (800-900 words)... This may take 30-45 seconds...</div>');
        
        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'gf_generate_ai_summary',
                form_id: formId,
                entry_id: entryId,
                custom_prompt: customPrompt,
                nonce: '<?php echo wp_create_nonce("gf_ai_summary_nonce"); ?>'
            },
            success: function(response) {
                button.prop('disabled', false);
                
                if (response.success) {
                    currentSummary = response.data.summary;
                    var pdfInfo = response.data.pdf_info || '';
                    var wordCount = response.data.word_count || 'N/A';
                    
                    resultDiv.html(
                        '<div style="background:#f8f9fa; padding:15px; border-radius:4px; margin-bottom:15px;">' +
                        '<h4 style="margin-top:0;">Summary Generated Successfully</h4>' +
                        '<p><strong>Word Count:</strong> ' + wordCount + ' words</p>' +
                        (pdfInfo ? '<p>' + pdfInfo + '</p>' : '') +
                        '</div>' +
                        '<h4 style="margin-top:0;">Preview (first 500 characters):</h4>' +
                        '<div style="white-space: pre-wrap; line-height: 1.6; margin-bottom: 15px; padding:15px; background:#fff; border:1px solid #ddd; border-radius:4px; max-height:300px; overflow-y:auto;">' + 
                        (currentSummary.length > 500 ? currentSummary.substring(0, 500) + '...' : currentSummary) + 
                        '</div>' +
                        '<div style="margin-top:15px;">' +
                        '<button class="button button-primary" onclick="saveSummaryToField(' + formId + ', ' + entryId + ')">' +
                        '<span class="dashicons dashicons-yes-alt" style="vertical-align:middle; margin-right:5px;"></span>' +
                        'Save to Field 103</button>' +
                        '<button class="button" onclick="copyToClipboard()" style="margin-left:10px;">' +
                        '<span class="dashicons dashicons-clipboard" style="vertical-align:middle; margin-right:5px;"></span>' +
                        'Copy to Clipboard</button>' +
                        '<button class="button" onclick="viewFullSummary()" style="margin-left:10px;">' +
                        '<span class="dashicons dashicons-visibility" style="vertical-align:middle; margin-right:5px;"></span>' +
                        'View Full Summary</button>' +
                        '</div>' +
                        '<div id="save-success-msg" style="display:none;background:#d4edda;padding:10px;margin-top:10px;border-radius:4px;">Summary saved to field 103!</div>' +
                        '<div id="save-error-msg" style="display:none;background:#f8d7da;padding:10px;margin-top:10px;border-radius:4px;"></div>'
                    );
                } else {
                    resultDiv.html('<div style="background:#f8d7da;color:#721c24;padding:15px;border-radius:4px;"><p><strong>Error:</strong> ' + response.data + '</p></div>');
                }
            },
            error: function(xhr, status, error) {
                button.prop('disabled', false);
                resultDiv.html('<div style="background:#f8d7da;color:#721c24;padding:15px;border-radius:4px;"><p><strong>Request failed:</strong> ' + error + '</p></div>');
            }
        });
    }
    
    function viewFullSummary() {
        if (!currentSummary) return;
        
        var modal = jQuery('<div id="full-summary-modal" style="position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.8);z-index:100000;display:flex;align-items:center;justify-content:center;">' +
            '<div style="background:white;padding:30px;border-radius:8px;width:90%;max-width:900px;max-height:90vh;overflow-y:auto;position:relative;">' +
            '<button onclick="jQuery(\'#full-summary-modal\').remove()" style="position:absolute;top:10px;right:10px;background:none;border:none;font-size:24px;cursor:pointer;">×</button>' +
            '<h3 style="margin-top:0;padding-right:30px;">Full AI Summary</h3>' +
            '<div style="white-space: pre-wrap; line-height: 1.7; font-size: 15px; padding:15px; background:#f9f9f9; border-radius:4px;">' + 
            currentSummary + 
            '</div>' +
            '</div>' +
            '</div>');
        
        jQuery('body').append(modal);
    }
    
    function saveSummaryToField(formId, entryId) {
        if (!currentSummary) return;
        
        var saveBtn = jQuery('#ai-summary-result .button-primary');
        var originalText = saveBtn.html();
        
        saveBtn.prop('disabled', true);
        saveBtn.html('<span class="spinner is-active" style="float:none; margin:0 5px;"></span> Saving...');
        
        jQuery('#save-success-msg').hide();
        jQuery('#save-error-msg').hide();
        
        jQuery.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'gf_save_ai_summary',
                form_id: formId,
                entry_id: entryId,
                summary: currentSummary,
                nonce: '<?php echo wp_create_nonce("gf_save_summary_nonce"); ?>'
            },
            success: function(response) {
                saveBtn.prop('disabled', false);
                saveBtn.html(originalText);
                
                if (response.success) {
                    jQuery('#save-success-msg').show().html('<span class="dashicons dashicons-saved" style="vertical-align:middle; margin-right:5px;"></span>' + response.data);
                    
                    // Close modal after 3 seconds
                    setTimeout(function() {
                        closeAISummary();
                        location.reload(); // Refresh to see the updated field
                    }, 3000);
                } else {
                    jQuery('#save-error-msg').html('<strong>Error:</strong> ' + response.data).show();
                }
            },
            error: function() {
                saveBtn.prop('disabled', false);
                saveBtn.html(originalText);
                jQuery('#save-error-msg').html('<strong>Network error:</strong> Failed to save summary.').show();
            }
        });
    }
    
    function copyToClipboard() {
        if (!currentSummary) return;
        
        var textarea = document.createElement('textarea');
        textarea.value = currentSummary;
        textarea.style.position = 'fixed';
        textarea.style.opacity = '0';
        document.body.appendChild(textarea);
        textarea.select();
        
        try {
            document.execCommand('copy');
            alert('Summary copied to clipboard!');
        } catch (err) {
            alert('Error copying to clipboard.');
        }
        
        document.body.removeChild(textarea);
    }
    </script>
    <?php
}

// 3. Auto-generate summary on form submission
add_action('gform_after_submission', 'auto_generate_ai_summary_on_submission', 10, 2);
function auto_generate_ai_summary_on_submission($entry, $form) {
    
    $auto_generate = get_option('gf_ai_auto_generate_' . $form['id'], false);
    
    if (!$auto_generate) {
        return;
    }
    
    $entry_id = $entry['id'];
    $form_id = $form['id'];
    
    // Generate AI summary
    $result = generate_ai_summary_for_entry($entry, $form);
    
    if (!is_wp_error($result)) {
        $summary = $result['summary'];
        
        // Save summary to field 103
        $entry['103'] = $summary;
        $update_result = GFAPI::update_entry($entry, $entry_id);
        
        if (!is_wp_error($update_result)) {
            gform_update_meta($entry_id, 'ai_summary_generated', current_time('mysql'));
            gform_update_meta($entry_id, 'ai_summary_content', $summary);
            gform_update_meta($entry_id, 'ai_summary_auto_generated', 'yes');
            
            if (isset($result['pdf_info'])) {
                gform_update_meta($entry_id, 'ai_pdf_processing_info', $result['pdf_info']);
            }
            
            if (isset($result['word_count'])) {
                gform_update_meta($entry_id, 'ai_summary_word_count', $result['word_count']);
            }
        }
    }
}

// 4. INCLUDE SIMPLE PDF PARSER CLASS (No external dependencies needed)
if (!class_exists('SimplePDFParser')) {
    class SimplePDFParser {
        /**
         * Extract text from PDF using simple PHP methods (no external dependencies)
         * This is a basic parser that works for many PDFs
         */
        public static function extractText($file_path) {
            if (!file_exists($file_path)) {
                return new WP_Error('pdf_not_found', 'PDF file not found');
            }
            
            // Read PDF file as binary
            $pdf_content = file_get_contents($file_path);
            
            if (empty($pdf_content)) {
                return new WP_Error('pdf_empty', 'PDF file is empty');
            }
            
            // Method 1: Try to extract text between text objects (common PDF structure)
            $text = self::extractTextFromPDFContent($pdf_content);
            
            if (!empty($text)) {
                return $text;
            }
            
            // Method 2: Try alternative extraction for different PDF formats
            $text = self::extractTextAlternative($pdf_content);
            
            if (!empty($text)) {
                return $text;
            }
            
            return new WP_Error('pdf_extraction_failed', 'Could not extract text from PDF (PDF may be scanned/image-based)');
        }
        
        private static function extractTextFromPDFContent($content) {
            $text = '';
            
            // Look for text objects in PDF (BT ... ET)
            preg_match_all('/BT\s*(.*?)\s*ET/s', $content, $matches);
            
            if (!empty($matches[1])) {
                foreach ($matches[1] as $text_obj) {
                    // Extract text from Tj and TJ operators
                    preg_match_all('/\((.*?)\)/s', $text_obj, $text_matches);
                    foreach ($text_matches[1] as $text_part) {
                        $text .= $text_part . ' ';
                    }
                    
                    // Also look for text in TJ arrays
                    preg_match_all('/\[(.*?)\]/s', $text_obj, $array_matches);
                    foreach ($array_matches[1] as $array_text) {
                        // Extract text parts from array
                        preg_match_all('/\((.*?)\)/', $array_text, $array_text_matches);
                        foreach ($array_text_matches[1] as $array_text_part) {
                            $text .= $array_text_part . ' ';
                        }
                    }
                }
            }
            
            // Clean up the text
            $text = preg_replace('/\s+/', ' ', $text);
            $text = html_entity_decode($text, ENT_QUOTES, 'UTF-8');
            $text = preg_replace('/[^\x20-\x7E\x0A\x0D\xC2-\xF4\x80-\xBF]+/u', ' ', $text);
            
            return trim($text);
        }
        
        private static function extractTextAlternative($content) {
            $text = '';
            
            // Alternative method: Look for stream objects
            preg_match_all('/stream\s*(.*?)\s*endstream/si', $content, $stream_matches);
            
            if (!empty($stream_matches[1])) {
                foreach ($stream_matches[1] as $stream) {
                    // Try to decode if compressed
                    $decoded_stream = @gzuncompress($stream);
                    if ($decoded_stream === false) {
                        $decoded_stream = $stream;
                    }
                    
                    // Look for text in the stream
                    preg_match_all('/\((.*?)\)/s', $decoded_stream, $text_matches);
                    foreach ($text_matches[1] as $text_part) {
                        $text .= $text_part . ' ';
                    }
                }
            }
            
            // Another pattern: Look for text directly
            preg_match_all('/T[mdJ]?\s*\((.*?)\)/s', $content, $direct_matches);
            foreach ($direct_matches[1] as $direct_text) {
                $text .= $direct_text . ' ';
            }
            
            // Clean up
            $text = preg_replace('/\s+/', ' ', $text);
            $text = html_entity_decode($text, ENT_QUOTES, 'UTF-8');
            $text = preg_replace('/[^\x20-\x7E\x0A\x0D\xC2-\xF4\x80-\xBF]+/u', ' ', $text);
            
            return trim($text);
        }
        
        /**
         * Fallback method using shell_exec if available (most reliable)
         */
        public static function extractTextWithPdftotext($file_path) {
            if (!function_exists('shell_exec')) {
                return false;
            }
            
            $temp_file = tempnam(sys_get_temp_dir(), 'pdf_text_');
            $command = "pdftotext -layout " . escapeshellarg($file_path) . " " . escapeshellarg($temp_file) . " 2>&1";
            
            @shell_exec($command);
            
            if (file_exists($temp_file) && filesize($temp_file) > 0) {
                $text = file_get_contents($temp_file);
                unlink($temp_file);
                
                $text = preg_replace('/\s+/', ' ', $text);
                return trim($text);
            }
            
            return false;
        }
    }
}

// 5. Enhanced PDF text extraction function
function extract_text_from_pdf($file_path) {
    if (!file_exists($file_path)) {
        return new WP_Error('pdf_not_found', 'PDF file not found: ' . basename($file_path));
    }
    
    $file_size = filesize($file_path);
    if ($file_size > 50 * 1024 * 1024) { // 50MB limit
        return new WP_Error('pdf_too_large', 'PDF file is too large (max 50MB): ' . round($file_size/1024/1024, 2) . 'MB');
    }
    
    // First try pdftotext (most reliable if available)
    if (function_exists('shell_exec')) {
        $text = SimplePDFParser::extractTextWithPdftotext($file_path);
        if ($text !== false && !empty(trim($text))) {
            return $text;
        }
    }
    
    // Try our simple PHP parser
    $text = SimplePDFParser::extractText($file_path);
    
    if (!is_wp_error($text) && !empty(trim($text))) {
        return $text;
    }
    
    // Last resort: Return basic info about the PDF
    $file_info = [
        'filename' => basename($file_path),
        'size' => round($file_size / 1024, 2) . ' KB',
        'pages' => 'Unknown',
        'note' => 'Text extraction failed. This may be a scanned/image PDF.'
    ];
    
    return json_encode($file_info);
}

// 6. Extract PDFs specifically from fields ID 67 and 90
function extract_pdfs_from_specific_fields($entry) {
    $pdf_texts = [];
    $target_fields = [67, 90]; // Specific field IDs for PDF attachments
    
    foreach ($target_fields as $field_id) {
        if (!empty($entry[$field_id])) {
            $file_urls = json_decode($entry[$field_id]);
            
            if (!$file_urls) {
                $file_urls = array($entry[$field_id]);
            }
            
            foreach ($file_urls as $file_url) {
                $file_extension = strtolower(pathinfo($file_url, PATHINFO_EXTENSION));
                
                if ($file_extension === 'pdf') {
                    $upload_dir = wp_upload_dir();
                    $file_path = str_replace($upload_dir['baseurl'], $upload_dir['basedir'], $file_url);
                    
                    if (!file_exists($file_path)) {
                        $gf_upload_dir = GFFormsModel::get_upload_root();
                        $relative_path = str_replace($upload_dir['baseurl'] . '/', '', $file_url);
                        $file_path = $gf_upload_dir . $relative_path;
                    }
                    
                    if (file_exists($file_path)) {
                        $text = extract_text_from_pdf($file_path);
                        
                        if (!is_wp_error($text)) {
                            $pdf_name = basename($file_url);
                            $pdf_texts[] = [
                                'field_id' => $field_id,
                                'name' => $pdf_name,
                                'content' => $text,
                                'path' => $file_path,
                                'extraction_method' => 'success'
                            ];
                        } else {
                            // Store error info
                            $pdf_texts[] = [
                                'field_id' => $field_id,
                                'name' => basename($file_url),
                                'content' => 'PDF text extraction failed: ' . $text->get_error_message(),
                                'path' => $file_path,
                                'extraction_method' => 'failed'
                            ];
                        }
                    }
                }
            }
        }
    }
    
    return $pdf_texts;
}

// 7. Main function to generate comprehensive AI summary
function generate_ai_summary_for_entry($entry, $form, $custom_prompt = '') {
    
    // Extract PDFs from specific fields (67, 90)
    $pdf_texts = extract_pdfs_from_specific_fields($entry);
    $pdf_info = '';
    $successful_extractions = 0;
    
    if (!empty($pdf_texts)) {
        $pdf_count = count($pdf_texts);
        $successful_extractions = count(array_filter($pdf_texts, function($pdf) {
            return $pdf['extraction_method'] === 'success';
        }));
        
        $fields_used = array_unique(array_column($pdf_texts, 'field_id'));
        $pdf_info = "Processed {$pdf_count} PDF file(s) from field(s): " . implode(', ', $fields_used);
        $pdf_info .= ". Successfully extracted text from {$successful_extractions} file(s).";
    } else {
        $pdf_info = "No PDF files found in fields 67 or 90.";
    }
    
    // Prepare form data - exclude PDF fields since we're processing them separately
    $formatted_data = [];
    foreach ($form['fields'] as $field) {
        $field_id = $field->id;
        $label = $field->label;
        $value = isset($entry[$field_id]) ? $entry[$field_id] : '';
        
        // Skip PDF fields (67, 90) since we're processing them separately
        if (in_array($field_id, [67, 90])) {
            continue;
        }
        
        if (!empty($value)) {
            $formatted_data[] = [
                'field' => $label,
                'value' => $value
            ];
        }
    }
    
    // Add metadata
    $formatted_data[] = ['field' => 'Entry Date', 'value' => $entry['date_created']];
    $formatted_data[] = ['field' => 'Entry ID', 'value' => $entry['id']];
    
    // Build combined text
    $combined_text = "=== FORM SUBMISSION DETAILS ===\n\n";
    
    foreach ($formatted_data as $item) {
        $combined_text .= "**{$item['field']}:** {$item['value']}\n";
    }
    
    $combined_text .= "\n\n=== PDF DOCUMENT CONTENTS ===\n\n";
    
    if (!empty($pdf_texts)) {
        foreach ($pdf_texts as $index => $pdf_data) {
            $field_id = $pdf_data['field_id'];
            $pdf_name = $pdf_data['name'];
            $pdf_content = $pdf_data['content'];
            $method = $pdf_data['extraction_method'];
            
            $combined_text .= "**PDF Document " . ($index + 1) . "** (Attached to Field {$field_id} - {$pdf_name})\n";
            $combined_text .= "Extraction Status: " . ($method === 'success' ? 'Successful' : 'Failed') . "\n";
            
            if ($method === 'success') {
                // Limit PDF content to avoid exceeding token limits
                $content_preview = strlen($pdf_content) > 15000 
                    ? substr($pdf_content, 0, 15000) . "... [content truncated]" 
                    : $pdf_content;
                $combined_text .= "Content:\n" . $content_preview . "\n\n";
            } else {
                $combined_text .= "Note: " . $pdf_content . "\n\n";
            }
        }
    } else {
        $combined_text .= "No PDF documents were attached to this submission.\n\n";
    }
    
    // Prepare detailed AI prompt for comprehensive summary
    $instructions = "ANALYSIS TASK: Create a comprehensive, well-structured summary of this form submission with attached documents.\n\n";
    $instructions .= "REQUIREMENTS:\n";
    $instructions .= "1. Length: 800-900 words total\n";
    $instructions .= "2. Structure: Use H3 headings (### Heading) to organize different sections\n";
    $instructions .= "3. Content: Combine information from form fields and PDF documents\n";
    $instructions .= "4. Style: Professional, clear, and comprehensive\n\n";
    
    $instructions .= "OUTLINE STRUCTURE:\n";
    $instructions .= "### Executive Summary\n[Brief overview of the entire submission]\n\n";
    $instructions .= "### Form Submission Details\n[Organized summary of key form field information]\n\n";
    
    if (!empty($pdf_texts)) {
        $instructions .= "### Document Analysis\n[Key findings, data, and information extracted from PDFs]\n\n";
        $instructions .= "### Cross-Reference Analysis\n[Connections between form data and document content]\n\n";
    }
    
    $instructions .= "### Key Findings and Insights\n[Important observations and insights]\n\n";
    $instructions .= "### Recommendations and Next Steps\n[If applicable, based on the submission]\n\n";
    
    $instructions .= "SPECIFIC INSTRUCTIONS:\n";
    $instructions .= "- Be thorough but concise\n";
    $instructions .= "- Highlight important dates, names, figures, and key information\n";
    $instructions .= "- If PDFs contain specific data (like financials, reports, etc.), summarize them clearly\n";
    $instructions .= "- Maintain professional tone\n";
    $instructions .= "- Ensure the summary is self-contained and understandable on its own\n\n";
    
    if (!empty($custom_prompt)) {
        $instructions .= "ADDITIONAL USER INSTRUCTIONS:\n{$custom_prompt}\n\n";
    }
    
    $instructions .= "NOW ANALYZE THIS SUBMISSION:\n\n" . $combined_text;
    
    // Call Sambanova API
    $api_key = '8af47ef7-8a72-45e3-ad9c-6b5d3f44ccca';
    $api_url = 'https://api.sambanova.ai/v1/chat/completions';
    
    $messages = [
        [
            'role' => 'system',
            'content' => 'You are a professional analyst specialized in creating comprehensive summaries of form submissions with document attachments. You create detailed, well-structured summaries with H3 headings, around 800-900 words, that combine information from form fields and attached documents.'
        ],
        [
            'role' => 'user',
            'content' => $instructions
        ]
    ];
    
    $body = [
        'stream' => false,
        'model' => 'DeepSeek-V3.1',
        'messages' => $messages,
        'max_tokens' => 4000, // Increased for longer summary
        'temperature' => 0.7
    ];
    
    $args = [
        'headers' => [
            'Authorization' => 'Bearer ' . $api_key,
            'Content-Type' => 'application/json',
        ],
        'body' => json_encode($body),
        'timeout' => 90, // Longer timeout for comprehensive summary
    ];
    
    $response = wp_remote_post($api_url, $args);
    
    if (is_wp_error($response)) {
        error_log('AI Summary API Error: ' . $response->get_error_message());
        return new WP_Error('api_error', $response->get_error_message());
    }
    
    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);
    
    if (isset($data['choices'][0]['message']['content'])) {
        $summary = wp_kses_post($data['choices'][0]['message']['content']);
        $word_count = str_word_count(strip_tags($summary));
        
        $result = [
            'summary' => $summary,
            'word_count' => $word_count,
            'pdf_info' => $pdf_info
        ];
        
        return $result;
    }
    
    error_log('AI Summary Generation Failed');
    return new WP_Error('generation_failed', 'Failed to generate summary');
}

// 8. AJAX handler for generating summary
add_action('wp_ajax_gf_generate_ai_summary', 'handle_gf_ai_summary_request');
function handle_gf_ai_summary_request() {
    if (!wp_verify_nonce($_POST['nonce'], 'gf_ai_summary_nonce')) {
        wp_send_json_error('Security check failed');
    }
    
    $form_id = intval($_POST['form_id']);
    $entry_id = intval($_POST['entry_id']);
    $custom_prompt = sanitize_textarea_field($_POST['custom_prompt'] ?? '');
    
    $entry = GFAPI::get_entry($entry_id);
    $form = GFAPI::get_form($form_id);
    
    if (is_wp_error($entry) || is_wp_error($form)) {
        wp_send_json_error('Could not load entry data.');
    }
    
    $result = generate_ai_summary_for_entry($entry, $form, $custom_prompt);
    
    if (is_wp_error($result)) {
        wp_send_json_error($result->get_error_message());
    }
    
    wp_send_json_success($result);
}

// 9. AJAX handler for saving summary
add_action('wp_ajax_gf_save_ai_summary', 'handle_save_ai_summary_request');
function handle_save_ai_summary_request() {
    if (!wp_verify_nonce($_POST['nonce'], 'gf_save_summary_nonce')) {
        wp_send_json_error('Security check failed');
    }
    
    $form_id = intval($_POST['form_id']);
    $entry_id = intval($_POST['entry_id']);
    $summary = wp_kses_post($_POST['summary']);
    
    $entry = GFAPI::get_entry($entry_id);
    if (is_wp_error($entry)) {
        wp_send_json_error('Could not load entry: ' . $entry->get_error_message());
    }
    
    $entry['103'] = $summary;
    $result = GFAPI::update_entry($entry, $entry_id);
    
    if (is_wp_error($result)) {
        wp_send_json_error('Failed to save summary: ' . $result->get_error_message());
    }
    
    // Calculate and save word count
    $word_count = str_word_count(strip_tags($summary));
    
    gform_update_meta($entry_id, 'ai_summary_generated', current_time('mysql'));
    gform_update_meta($entry_id, 'ai_summary_content', $summary);
    gform_update_meta($entry_id, 'ai_summary_word_count', $word_count);
    
    wp_send_json_success('Summary (' . $word_count . ' words) saved to field ID 103 successfully!');
}

// 10. Admin settings page
add_action('admin_menu', 'add_ai_summary_settings_page');
function add_ai_summary_settings_page() {
    add_submenu_page(
        'gf_edit_forms',
        'AI Summary Settings',
        'AI Summary Settings',
        'manage_options',
        'gf-ai-summary-settings',
        'render_ai_summary_settings_page'
    );
}

function render_ai_summary_settings_page() {
    if (!current_user_can('manage_options')) {
        wp_die('You do not have sufficient permissions to access this page.');
    }
    
    // Check PDF support
    $pdf_support = check_pdf_extraction_support();
    
    if (isset($_POST['save_ai_settings']) && wp_verify_nonce($_POST['ai_settings_nonce'], 'save_ai_settings')) {
        $forms = GFAPI::get_forms();
        foreach ($forms as $form) {
            $form_id = $form['id'];
            $auto_generate = isset($_POST['auto_generate'][$form_id]) ? 1 : 0;
            update_option('gf_ai_auto_generate_' . $form_id, $auto_generate);
        }
        
        echo '<div class="notice notice-success"><p>Settings saved successfully!</p></div>';
    }
    
    $forms = GFAPI::get_forms();
    ?>
    <div class="wrap">
        <h1>AI Summary Settings</h1>
        
        <div class="card" style="margin-bottom: 20px;">
            <h3>Configuration Summary</h3>
            <ul>
                <li><strong>PDF Source Fields:</strong> 67, 90</li>
                <li><strong>Summary Output Field:</strong> 103</li>
                <li><strong>Target Length:</strong> 800-900 words</li>
                <li><strong>Format:</strong> H3 headings with clear paragraphs</li>
                <li><strong>PDF Extraction Method:</strong> Built-in PHP parser (no external dependencies needed)</li>
                <li><strong>Fallback Option:</strong> Will use pdftotext if available on server</li>
            </ul>
            
            <?php if (!$pdf_support['pdftotext']): ?>
                <div class="notice notice-info">
                    <p><strong>Note:</strong> Using built-in PHP PDF parser. For better PDF extraction, you can install pdftotext on your server:</p>
                    <code>sudo apt-get install poppler-utils</code>
                </div>
            <?php else: ?>
                <div class="notice notice-success">
                    <p><strong>✓ pdftotext is available on your server for reliable PDF extraction.</strong></p>
                </div>
            <?php endif; ?>
        </div>
        
        <form method="post" action="">
            <?php wp_nonce_field('save_ai_settings', 'ai_settings_nonce'); ?>
            
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th style="width: 50px;">Auto-Generate</th>
                        <th>Form ID</th>
                        <th>Form Title</th>
                        <th>PDF Fields Check</th>
                        <th>Summary Field</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($forms as $form): 
                        $form_id = $form['id'];
                        $auto_generate = get_option('gf_ai_auto_generate_' . $form_id, false);
                        
                        // Check if form has fields 67, 90, and 103
                        $has_field_67 = false;
                        $has_field_90 = false;
                        $has_field_103 = false;
                        
                        foreach ($form['fields'] as $field) {
                            if ($field->id == 67) $has_field_67 = true;
                            if ($field->id == 90) $has_field_90 = true;
                            if ($field->id == 103) $has_field_103 = true;
                        }
                    ?>
                    <tr>
                        <td>
                            <input type="checkbox" name="auto_generate[<?php echo $form_id; ?>]" value="1" 
                                <?php checked($auto_generate, 1); ?>>
                        </td>
                        <td><?php echo $form_id; ?></td>
                        <td><strong><?php echo esc_html($form['title']); ?></strong></td>
                        <td>
                            <?php if ($has_field_67 && $has_field_90): ?>
                                <span style="color:#46b450;">✅ Fields 67 & 90 present</span>
                            <?php elseif ($has_field_67 || $has_field_90): ?>
                                <span style="color:#ffb900;">⚠️ Partial: Field <?php echo $has_field_67 ? '67' : ''; ?><?php echo $has_field_67 && $has_field_90 ? ' & ' : ''; ?><?php echo $has_field_90 ? '90' : ''; ?> present</span>
                            <?php else: ?>
                                <span style="color:#dc3232;">❌ Fields 67 & 90 not found</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($has_field_103): ?>
                                <span style="color:#46b450;">✅ Field 103 present</span>
                            <?php else: ?>
                                <span style="color:#dc3232;">❌ Field 103 not found</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <p class="submit">
                <input type="submit" name="save_ai_settings" class="button-primary" value="Save Settings">
            </p>
        </form>
    </div>
    <?php
}

function check_pdf_extraction_support() {
    $support = [
        'pdftotext' => false,
        'any' => true // Our built-in parser always works
    ];
    
    if (function_exists('shell_exec')) {
        $output = @shell_exec('which pdftotext');
        $support['pdftotext'] = !empty($output);
    }
    
    return $support;
}

// 11. Display summary info in entry detail
add_action('gform_entry_detail_content_before', 'show_ai_summary_info', 10, 2);
function show_ai_summary_info($form, $entry) {
    $summary_generated = gform_get_meta($entry['id'], 'ai_summary_generated');
    $summary_content = gform_get_meta($entry['id'], 'ai_summary_content');
    $word_count = gform_get_meta($entry['id'], 'ai_summary_word_count');
    $pdf_info = gform_get_meta($entry['id'], 'ai_pdf_processing_info');
    
    if ($summary_generated) {
        echo '<div class="notice notice-info" style="margin: 10px 0; padding: 15px;">';
        echo '<h3 style="margin-top:0;">AI Summary Information</h3>';
        echo '<p><strong>Generated:</strong> ' . date_i18n('F j, Y g:i a', strtotime($summary_generated)) . '</p>';
        
        if ($word_count) {
            echo '<p><strong>Word Count:</strong> ' . $word_count . ' words</p>';
        }
        
        if ($pdf_info) {
            echo '<p><strong>PDF Processing:</strong> ' . esc_html($pdf_info) . '</p>';
        }
        
        if (isset($entry['103']) && !empty($entry['103'])) {
            echo '<div style="background:#f5f5f5; padding:15px; margin-top:15px; border-radius:4px; border:1px solid #ddd;">';
            echo '<h4 style="margin-top:0;">Summary Preview (Field 103):</h4>';
            echo '<div style="max-height:300px; overflow-y:auto; white-space:pre-wrap; font-size:14px; line-height:1.6; padding:10px; background:#fff;">';
            
            // Show first 800 characters with H3 headings preserved
            $preview = $entry['103'];
            if (strlen($preview) > 800) {
                $preview = substr($preview, 0, 800) . '...';
            }
            echo esc_html($preview);
            
            echo '</div>';
            echo '<p style="margin-top:10px; margin-bottom:0;"><em>Full summary (' . $word_count . ' words) stored in field ID 103</em></p>';
            echo '</div>';
        }
        
        echo '</div>';
    }
}
// Put the code of your snippet below this comment.