<?php
/**
 * New custom code snippet (replace this with snippet description).
 */

toolset_snippet_security_check() or die( 'Direct access is not allowed' );


/**
 * Plugin Name: SambaNova API Tester Shortcode
 * Description: Test SambaNova API with shortcode [test_sambanova_api]
 * Version: 1.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Register the shortcode
add_shortcode('test_sambanova_api', 'sambanova_api_test_shortcode');

function sambanova_api_test_shortcode($atts) {
    // Shortcode attributes
    $atts = shortcode_atts(array(
        'api_key' => '8af47ef7-8a72-45e3-ad9c-6b5d3f44ccca', // You can pass API key via shortcode attribute
        'user_message' => 'Hello',
        'system_message' => 'You are a helpful assistant',
        'model' => 'DeepSeek-V3.1',
        'stream' => 'false', // true or false
        'max_tokens' => 100,
        'temperature' => 0.7,
        'show_key' => 'no', // Show masked API key? yes/no
        'button_text' => 'Test SambaNova API Now',
        'debug' => 'no', // Show debug info? yes/no
        'show_raw' => 'no' // Show raw API response
    ), $atts);
    
    // Convert string boolean to actual boolean
    $stream = ($atts['stream'] === 'true' || $atts['stream'] === '1');
    
    // Use API key from shortcode attribute, or get from saved option
    $api_key = !empty($atts['api_key']) ? $atts['api_key'] : get_option('sambanova_api_key', '');
    
    // If no API key is found anywhere
    if (empty($api_key)) {
        return '<div class="sambanova-api-test error">
            <p><strong>Error:</strong> No API key provided. Add your API key in the shortcode like [test_sambanova_api api_key="your_key_here"] or set it in WordPress settings.</p>
        </div>';
    }
    
    // Check if form was submitted
    $test_result = '';
    if (isset($_POST['test_sambanova_api']) && wp_verify_nonce($_POST['_wpnonce'], 'test_sambanova_action')) {
        $test_result = test_sambanova_api_function($api_key, $atts, $stream);
    }
    
    // Start output
    ob_start();
    ?>
    
    <div class="sambanova-api-test-wrapper">
        <style>
            .sambanova-api-test { padding: 20px; margin: 20px 0; border-radius: 5px; }
            .sambanova-api-test.success { background: #d4edda; border: 1px solid #c3e6cb; color: #155724; }
            .sambanova-api-test.error { background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; }
            .sambanova-api-test.info { background: #d1ecf1; border: 1px solid #bee5eb; color: #0c5460; }
            .sambanova-api-test pre { background: #f8f9fa; padding: 10px; border-radius: 3px; overflow-x: auto; font-size: 12px; }
            .sambanova-test-button { 
                background: #6a0dad; 
                color: white; 
                padding: 10px 20px; 
                border: none; 
                border-radius: 3px; 
                cursor: pointer; 
                font-size: 16px;
                margin: 10px 0;
            }
            .sambanova-test-button:hover { background: #5a0b9a; }
            .api-key-display { 
                background: #f0f0f1; 
                padding: 10px; 
                font-family: monospace; 
                margin: 10px 0;
                word-break: break-all;
                border-left: 4px solid #6a0dad;
            }
            .test-config { 
                background: #f8f9fa; 
                padding: 15px; 
                margin: 15px 0; 
                border-radius: 5px;
                border: 1px solid #e0e0e0;
            }
            .config-label { font-weight: bold; color: #555; }
            .config-value { color: #333; }
        </style>
        
        <h3 style="color: #6a0dad;">SambaNova API Test</h3>
        
        <?php if ($atts['show_key'] === 'yes') : ?>
            <div class="api-key-display">
                <strong>API Key Status:</strong> 
                <?php 
                // Show masked API key for security
                $masked_key = substr($api_key, 0, 8) . str_repeat('*', max(0, strlen($api_key) - 12)) . substr($api_key, -4);
                echo $masked_key . ' (' . strlen($api_key) . ' characters)';
                ?>
            </div>
        <?php endif; ?>
        
        <div class="test-config">
            <h4>Test Configuration:</h4>
            <table>
                <tr><td class="config-label">Model:</td><td class="config-value"><?php echo esc_html($atts['model']); ?></td></tr>
                <tr><td class="config-label">Stream:</td><td class="config-value"><?php echo $stream ? 'true' : 'false'; ?></td></tr>
                <tr><td class="config-label">System Message:</td><td class="config-value">"<?php echo esc_html($atts['system_message']); ?>"</td></tr>
                <tr><td class="config-label">User Message:</td><td class="config-value">"<?php echo esc_html($atts['user_message']); ?>"</td></tr>
                <tr><td class="config-label">Max Tokens:</td><td class="config-value"><?php echo esc_html($atts['max_tokens']); ?></td></tr>
                <tr><td class="config-label">Temperature:</td><td class="config-value"><?php echo esc_html($atts['temperature']); ?></td></tr>
            </table>
        </div>
        
        <form method="post">
            <?php wp_nonce_field('test_sambanova_action'); ?>
            <input type="hidden" name="test_sambanova_api" value="1">
            <p>
                <button type="submit" class="sambanova-test-button">
                    <?php echo esc_html($atts['button_text']); ?>
                </button>
            </p>
        </form>
        
        <?php if (!empty($test_result)) : ?>
            <div class="sambanova-api-test <?php echo esc_attr($test_result['status']); ?>">
                <h4>Test Result:</h4>
                <p><strong>Status:</strong> <?php echo esc_html($test_result['message']); ?></p>
                
                <?php if (isset($test_result['response'])) : ?>
                    <p><strong>AI Response:</strong></p>
                    <div style="background: white; padding: 15px; border-radius: 5px; border: 1px solid #ddd;">
                        <?php echo nl2br(esc_html($test_result['response'])); ?>
                    </div>
                <?php endif; ?>
                
                <?php if (isset($test_result['model'])) : ?>
                    <p><strong>Model Used:</strong> <?php echo esc_html($test_result['model']); ?></p>
                <?php endif; ?>
                
                <?php if (isset($test_result['usage'])) : ?>
                    <p><strong>Token Usage:</strong> 
                        Prompt: <?php echo esc_html($test_result['usage']['prompt_tokens'] ?? 0); ?>, 
                        Completion: <?php echo esc_html($test_result['usage']['completion_tokens'] ?? 0); ?>, 
                        Total: <?php echo esc_html($test_result['usage']['total_tokens'] ?? 0); ?>
                    </p>
                <?php endif; ?>
                
                <?php if ($atts['debug'] === 'yes' && isset($test_result['debug'])) : ?>
                    <div class="debug-info">
                        <h5>Debug Information:</h5>
                        <pre><?php echo esc_html(print_r($test_result['debug'], true)); ?></pre>
                    </div>
                <?php endif; ?>
                
                <?php if ($atts['show_raw'] === 'yes' && isset($test_result['raw_response'])) : ?>
                    <div class="raw-response">
                        <h5>Raw API Response:</h5>
                        <pre><?php echo esc_html(json_encode($test_result['raw_response'], JSON_PRETTY_PRINT)); ?></pre>
                    </div>
                <?php endif; ?>
                
                <?php if (isset($test_result['response_time'])) : ?>
                    <p><small>Response time: <?php echo esc_html($test_result['response_time']); ?> seconds</small></p>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        
        <hr>
        <p style="font-size: 12px; color: #666;">
            <strong>API Endpoint:</strong> https://api.sambanova.ai/v1/chat/completions<br>
            <strong>Shortcode:</strong> <code>[test_sambanova_api]</code>
        </p>
    </div>
    
    <?php
    return ob_get_clean();
}

// Function to test the SambaNova API
function test_sambanova_api_function($api_key, $atts, $stream = false) {
    $api_url = 'https://api.sambanova.ai/v1/chat/completions';
    
    // Start timing
    $start_time = microtime(true);
    
    // Prepare the request body (EXACTLY as in your curl example)
    $body = array(
        'stream' => $stream,
        'model' => $atts['model'],
        'messages' => array(
            array(
                'role' => 'system',
                'content' => $atts['system_message']
            ),
            array(
                'role' => 'user',
                'content' => $atts['user_message']
            )
        ),
        'max_tokens' => intval($atts['max_tokens']),
        'temperature' => floatval($atts['temperature'])
    );
    
    // Headers (EXACTLY as in your curl example)
    $headers = array(
        'Authorization' => 'Bearer ' . $api_key,
        'Content-Type' => 'application/json',
    );
    
    $args = array(
        'method' => 'POST',
        'headers' => $headers,
        'body' => json_encode($body),
        'timeout' => 60, // Longer timeout for API calls
        'sslverify' => true
    );
    
    // Make the API request
    $response = wp_remote_post($api_url, $args);
    
    // End timing
    $end_time = microtime(true);
    $response_time = round($end_time - $start_time, 2);
    
    // Initialize result array
    $result = array(
        'status' => 'error',
        'message' => '',
        'response' => '',
        'response_time' => $response_time . 's'
    );
    
    // For debugging
    if ($atts['debug'] === 'yes') {
        $result['debug'] = array(
            'request_url' => $api_url,
            'request_headers' => array(
                'Authorization' => 'Bearer ' . substr($api_key, 0, 8) . '...' . substr($api_key, -4),
                'Content-Type' => 'application/json'
            ),
            'request_body' => $body,
            'full_request' => $args
        );
    }
    
    // Check for WordPress errors
    if (is_wp_error($response)) {
        $result['message'] = 'WordPress Error: ' . $response->get_error_message();
        if ($atts['debug'] === 'yes') {
            $result['debug']['wp_error'] = $response->get_error_messages();
        }
        return $result;
    }
    
    $response_code = wp_remote_retrieve_response_code($response);
    $response_body = wp_remote_retrieve_body($response);
    $response_data = json_decode($response_body, true);
    
    // Store raw response for display if needed
    $result['raw_response'] = $response_data;
    
    if ($atts['debug'] === 'yes') {
        $result['debug']['response_code'] = $response_code;
        $result['debug']['response_headers'] = wp_remote_retrieve_headers($response);
        $result['debug']['response_body'] = $response_body;
    }
    
    // Check HTTP response code
    if ($response_code === 200) {
        // Success
        if ($stream === true) {
            // Handle streaming response (simplified for shortcode)
            $result['status'] = 'success';
            $result['message'] = '✅ API Key is valid! Streaming response received (HTTP 200)';
            $result['response'] = 'Streaming response - check raw response for details';
        } else {
            // Standard response
            $answer = isset($response_data['choices'][0]['message']['content']) 
                    ? trim($response_data['choices'][0]['message']['content']) 
                    : 'Success - API responded but no message content';
            
            $result['status'] = 'success';
            $result['message'] = '✅ API Key is valid and working! (HTTP 200)';
            $result['response'] = $answer;
            
            if (isset($response_data['model'])) {
                $result['model'] = $response_data['model'];
            }
            
            if (isset($response_data['usage'])) {
                $result['usage'] = $response_data['usage'];
            }
            
            if (isset($response_data['id'])) {
                $result['request_id'] = $response_data['id'];
            }
        }
        
    } elseif ($response_code === 401) {
        // Unauthorized
        $result['message'] = '❌ Invalid API key (401 Unauthorized)';
        if (isset($response_data['error']['message'])) {
            $result['response'] = $response_data['error']['message'];
        }
        
    } elseif ($response_code === 429) {
        // Rate limit
        $result['message'] = '⚠️ Rate limit exceeded (429 Too Many Requests)';
        if (isset($response_data['error']['message'])) {
            $result['response'] = $response_data['error']['message'];
        }
        
    } elseif ($response_code === 400) {
        // Bad request
        $result['message'] = '⚠️ Bad request (400)';
        if (isset($response_data['error']['message'])) {
            $result['response'] = $response_data['error']['message'];
        }
        
    } elseif ($response_code === 403) {
        // Forbidden
        $result['message'] = '❌ Forbidden (403) - Check API key permissions';
        if (isset($response_data['error']['message'])) {
            $result['response'] = $response_data['error']['message'];
        }
        
    } elseif ($response_code === 404) {
        // Not found
        $result['message'] = '❌ Endpoint not found (404)';
        
    } elseif ($response_code >= 500) {
        // Server error
        $result['message'] = '❌ Server error (HTTP ' . $response_code . ')';
        
    } else {
        // Other errors
        $error_message = isset($response_data['error']['message']) 
                       ? $response_data['error']['message'] 
                       : 'Unknown error (HTTP ' . $response_code . ')';
        
        $result['message'] = '❌ API Error: ' . $error_message;
    }
    
    return $result;
}

// Add settings page for API key
add_action('admin_menu', 'sambanova_api_test_menu');
function sambanova_api_test_menu() {
    add_options_page(
        'SambaNova API Settings',
        'SambaNova API',
        'manage_options',
        'sambanova-api-test',
        'sambanova_api_settings_page'
    );
}

function sambanova_api_settings_page() {
    ?>
    <div class="wrap">
        <h1 style="color: #6a0dad;">SambaNova API Settings</h1>
        
        <?php
        // Save settings if form was submitted
        if (isset($_POST['save_sambanova_settings']) && wp_verify_nonce($_POST['_wpnonce'], 'sambanova_settings')) {
            $api_key = sanitize_text_field($_POST['sambanova_api_key']);
            update_option('sambanova_api_key', $api_key);
            echo '<div class="notice notice-success"><p>Settings saved!</p></div>';
        }
        
        $current_key = get_option('sambanova_api_key', '');
        ?>
        
        <form method="post">
            <?php wp_nonce_field('sambanova_settings'); ?>
            <table class="form-table">
                <tr>
                    <th scope="row"><label for="sambanova_api_key">SambaNova API Key</label></th>
                    <td>
                        <input type="password" 
                               id="sambanova_api_key" 
                               name="sambanova_api_key" 
                               value="<?php echo esc_attr($current_key); ?>" 
                               class="regular-text"
                               placeholder="Enter your SambaNova API key">
                        <p class="description">Get your API key from <a href="https://cloud.sambanova.ai/" target="_blank">SambaNova Cloud</a></p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">Test Configuration</th>
                    <td>
                        <p><strong>Default Model:</strong> DeepSeek-V3.1</p>
                        <p><strong>API Endpoint:</strong> https://api.sambanova.ai/v1/chat/completions</p>
                    </td>
                </tr>
            </table>
            
            <p class="submit">
                <input type="submit" name="save_sambanova_settings" class="button-primary" value="Save API Key" style="background-color: #6a0dad; border-color: #5a0b9a;">
            </p>
        </form>
        
        <hr>
        
        <h2>Shortcode Usage</h2>
        <p>Use the shortcode <code>[test_sambanova_api]</code> on any page or post to test your SambaNova API.</p>
        
        <div class="card" style="max-width: 600px;">
            <h3>Example Test Results:</h3>
            <p>Using the exact curl command format you provided:</p>
            <pre style="background: #f6f6f6; padding: 15px;">
curl -H "Authorization: Bearer YOUR_API_KEY" \
     -H "Content-Type: application/json" \
     -d '{
    "stream": false,
    "model": "DeepSeek-V3.1",
    "messages": [
        {
            "role": "system",
            "content": "You are a helpful assistant"
        },
        {
            "role": "user",
            "content": "Hello"
        }
    ]
}' \
     -X POST https://api.sambanova.ai/v1/chat/completions</pre>
        </div>
        
        <h3>Shortcode Attributes:</h3>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th>Attribute</th>
                    <th>Default</th>
                    <th>Description</th>
                </tr>
            </thead>
            <tbody>
                <tr><td><code>api_key</code></td><td>(from settings)</td><td>Override the saved API key</td></tr>
                <tr><td><code>model</code></td><td>DeepSeek-V3.1</td><td>SambaNova model name</td></tr>
                <tr><td><code>stream</code></td><td>false</td><td>Enable streaming response (true/false)</td></tr>
                <tr><td><code>system_message</code></td><td>You are a helpful assistant</td><td>System prompt</td></tr>
                <tr><td><code>user_message</code></td><td>Hello</td><td>User message to send</td></tr>
                <tr><td><code>max_tokens</code></td><td>100</td><td>Maximum tokens in response</td></tr>
                <tr><td><code>temperature</code></td><td>0.7</td><td>Response creativity (0.0 to 1.0)</td></tr>
                <tr><td><code>show_key</code></td><td>no</td><td>Show masked API key (yes/no)</td></tr>
                <tr><td><code>debug</code></td><td>no</td><td>Show debug information (yes/no)</td></tr>
                <tr><td><code>show_raw</code></td><td>no</td><td>Show raw API response (yes/no)</td></tr>
            </tbody>
        </table>
        
        <h3>Examples:</h3>
        <pre>[test_sambanova_api]</pre>
        <pre>[test_sambanova_api user_message="What is machine learning?"]</pre>
        <pre>[test_sambanova_api model="DeepSeek-V3" system_message="You are a technical expert" max_tokens="200"]</pre>
        <pre>[test_sambanova_api api_key="sk-your-key-here" debug="yes" show_raw="yes"]</pre>
        <pre>[test_sambanova_api stream="true" show_key="yes"]</pre>
        
        <div class="notice notice-info">
            <p><strong>Note:</strong> This plugin makes EXACTLY the same API call as your curl command, with proper headers and JSON formatting.</p>
        </div>
    </div>
    <?php
}

// Add link to settings from plugins page
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'sambanova_api_test_settings_link');
function sambanova_api_test_settings_link($links) {
    $settings_link = '<a href="options-general.php?page=sambanova-api-test" style="color: #6a0dad; font-weight: bold;">Settings</a>';
    array_unshift($links, $settings_link);
    return $links;
}

// Add admin notice for empty API key
add_action('admin_notices', 'sambanova_api_key_notice');
function sambanova_api_key_notice() {
    $screen = get_current_screen();
    if ($screen->id === 'settings_page_sambanova-api-test') {
        $api_key = get_option('sambanova_api_key', '');
        if (empty($api_key)) {
            echo '<div class="notice notice-warning">
                <p><strong>SambaNova API Key Missing:</strong> Please enter your API key below to use the shortcode.</p>
            </div>';
        } else {
            $masked_key = substr($api_key, 0, 8) . str_repeat('*', max(0, strlen($api_key) - 12)) . substr($api_key, -4);
            echo '<div class="notice notice-success">
                <p><strong>API Key Configured:</strong> ' . esc_html($masked_key) . ' (<a href="https://cloud.sambanova.ai/" target="_blank">Get New Key</a>)</p>
            </div>';
        }
    }
}
// Put the code of your snippet below this comment.