<?php
/**
 * New custom code snippet (replace this with snippet description).
 */

toolset_snippet_security_check() or die( 'Direct access is not allowed' );function fix_multi_class_tooltip() {
    ?>
    <script type="text/javascript">
    jQuery(document).ready(function($) {
        function initMultiClassTooltips() {
            // Target the specific class combination
            $('.easygf-tooltip.icon.gform-field-label').each(function() {
                var $icon = $(this);
                console.log('Found multi-class icon:', $icon);
                
                // Find tooltip_content in various locations
                var $tooltipContent = findTooltipForIcon($icon);
                
                if ($tooltipContent.length) {
                    console.log('Found tooltip content for multi-class icon');
                    
                    // Apply forced styles - POSITION ABOVE ICON
                    $tooltipContent.css({
                        'display': 'none',
                        'position': 'absolute',
                        'z-index': '1000000',
                        'background': '#333',
                        'color': '#fff',
                        'padding': '12px 15px',
                        'border-radius': '5px',
                        'max-width': '380px',
                         'min-width': '330px',
                        'bottom': '100%',
                        'left': '50%',
                        'transform': 'translateX(-50%)',
                        'margin-bottom': '8px',
                        'box-shadow': '0 3px 15px rgba(0,0,0,0.3)'
                    });
                    
                    // Add speech bubble arrow
                    $tooltipContent.append('<div class="tooltip-arrow"></div>');
                    
                    // Hover functionality
                    $icon.hover(
                        function() {
                            $tooltipContent.stop(true, true).fadeIn(200);
                        },
                        function() {
                            setTimeout(function() {
                                if (!$tooltipContent.is(':hover')) {
                                    $tooltipContent.stop(true, true).fadeOut(200);
                                }
                            }, 100);
                        }
                    );
                    
                    $tooltipContent.hover(
                        function() {
                            $(this).stop(true, true).show();
                        },
                        function() {
                            $(this).stop(true, true).fadeOut(200);
                        }
                    );
                }
            });
        }
        
        function findTooltipForIcon($icon) {
            // Try different selectors to find the tooltip_content
            var selectors = [
                $icon.closest('.gfield_label').next('.tooltip_content'),
                $icon.closest('.gfield_label').siblings('.tooltip_content'),
                $icon.closest('.gfield').find('.tooltip_content'),
                $icon.closest('.gfield_label').parent().find('.tooltip_content'),
                $icon.closest('.gfield').find('.gfield_description').find('.tooltip_content')
            ];
            
            for (var i = 0; i < selectors.length; i++) {
                if (selectors[i].length > 0) {
                    return selectors[i];
                }
            }
            return $();
        }
        
        // Initialize
        initMultiClassTooltips();
        
        // Re-initialize on form events
        $(document).on('gform_post_render', function() {
            setTimeout(initMultiClassTooltips, 150);
        });
    });
    </script>
    
    <style>
    /* Tooltip speech bubble styles */
    .tooltip_content {
      
    }
    
    /* Speech bubble arrow at the bottom */
    .tooltip-arrow {
        position: absolute !important;
        top: 100% !important;
        left: 50% !important;
        transform: translateX(-50%) !important;
        width: 0 !important;
        height: 0 !important;
        border-left: 8px solid transparent !important;
        border-right: 8px solid transparent !important;
        border-top: 8px solid #333 !important;
    }
    
    /* Ensure proper positioning */
    .gfield_label {
        position: relative !important;
    }
    
    .tooltip_content {
        text-align: center !important;
        white-space: normal !important;
        word-wrap: break-word !important;
    }
    </style>
    <?php
}
add_action('wp_footer', 'fix_multi_class_tooltip');

// Put the code of your snippet below this comment.